/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import java.util.Arrays;
import org.geolatte.geom.AbstractPointSequenceBuilder;
import org.geolatte.geom.DimensionalFlag;
import org.geolatte.geom.PackedPointSequence;
import org.geolatte.geom.PointSequence;

class VariableSizePointSequenceBuilder
extends AbstractPointSequenceBuilder {
    private double[] coordinates;
    private int index = 0;

    VariableSizePointSequenceBuilder(DimensionalFlag flag) {
        super(flag);
        this.coordinates = new double[flag.getCoordinateDimension() * 10];
    }

    @Override
    protected void add(double val) {
        this.ensureCapacity();
        this.coordinates[this.index++] = val;
    }

    private void ensureCapacity() {
        if (this.index < this.coordinates.length) {
            return;
        }
        int newCapacity = this.coordinates.length * 3 / 2 + 1;
        this.coordinates = Arrays.copyOf(this.coordinates, newCapacity);
    }

    @Override
    public PointSequence toPointSequence() {
        return new PackedPointSequence(Arrays.copyOf(this.coordinates, this.index), this.dimensionalFlag);
    }
}

