/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import java.io.Serializable;
import java.util.Arrays;
import org.geolatte.geom.DimensionalFlag;
import org.geolatte.geom.PackedPointSequence;
import org.geolatte.geom.Point;
import org.geolatte.geom.crs.CrsId;

public class Points
implements Serializable {
    public static Point create(double x, double y, CrsId crsId) {
        return new Point(new PackedPointSequence(new double[]{x, y}, DimensionalFlag.XY), crsId);
    }

    public static Point create3D(double x, double y, double z, CrsId crsId) {
        return new Point(new PackedPointSequence(new double[]{x, y, z}, DimensionalFlag.XYZ), crsId);
    }

    public static Point createMeasured(double x, double y, double m, CrsId crsId) {
        return new Point(new PackedPointSequence(new double[]{x, y, m}, DimensionalFlag.XYM), crsId);
    }

    public static Point create(double x, double y, double z, double m, CrsId crsId) {
        return new Point(new PackedPointSequence(new double[]{x, y, z, m}, DimensionalFlag.XYZM), crsId);
    }

    public static Point create(double x, double y) {
        return new Point(new PackedPointSequence(new double[]{x, y}, DimensionalFlag.XY), CrsId.UNDEFINED);
    }

    public static Point create3D(double x, double y, double z) {
        return new Point(new PackedPointSequence(new double[]{x, y, z}, DimensionalFlag.XYZ), CrsId.UNDEFINED);
    }

    public static Point createMeasured(double x, double y, double m) {
        return new Point(new PackedPointSequence(new double[]{x, y, m}, DimensionalFlag.XYM), CrsId.UNDEFINED);
    }

    public static Point create(double x, double y, double z, double m) {
        return new Point(new PackedPointSequence(new double[]{x, y, z, m}, DimensionalFlag.XYZM), CrsId.UNDEFINED);
    }

    static Point create(double[] coordinates, DimensionalFlag dimensionalFlag, CrsId crsId) {
        if (coordinates == null || coordinates.length == 0) {
            return Point.createEmpty();
        }
        return new Point(new PackedPointSequence(Arrays.copyOf(coordinates, coordinates.length), dimensionalFlag), crsId);
    }

    public static Point createEmpty() {
        return Point.createEmpty();
    }
}

