/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import org.geolatte.geom.EmptyPointSequence;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryOperations;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.GeometryVisitor;
import org.geolatte.geom.PointSequence;
import org.geolatte.geom.crs.CrsId;

public class Point
extends Geometry {
    static final Point EMPTY = new Point(EmptyPointSequence.INSTANCE, CrsId.UNDEFINED, null);
    private final PointSequence points;

    public static Point createEmpty() {
        return EMPTY;
    }

    public Point(PointSequence sequence, CrsId crsId, GeometryOperations geometryOperations) {
        super(crsId, geometryOperations);
        this.points = sequence;
    }

    public Point(PointSequence sequence, CrsId crsId) {
        this(sequence, crsId, null);
    }

    @Override
    public PointSequence getPoints() {
        return this.points;
    }

    public double getX() {
        return this.isEmpty() ? Double.NaN : this.getPoints().getX(0);
    }

    public double getY() {
        return this.isEmpty() ? Double.NaN : this.getPoints().getY(0);
    }

    public double getZ() {
        return this.isEmpty() ? Double.NaN : this.getPoints().getZ(0);
    }

    public double getM() {
        return this.isEmpty() ? Double.NaN : this.getPoints().getM(0);
    }

    @Override
    public int getDimension() {
        return 0;
    }

    @Override
    public GeometryType getGeometryType() {
        return GeometryType.POINT;
    }

    @Override
    public boolean isSimple() {
        return true;
    }

    @Override
    public Geometry getBoundary() {
        return EMPTY;
    }

    @Override
    public void accept(GeometryVisitor visitor) {
        visitor.visit(this);
    }
}

