/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import java.util.Arrays;
import java.util.Iterator;
import org.geolatte.geom.AbstractPointCollection;
import org.geolatte.geom.ComplexPointCollection;
import org.geolatte.geom.CoordinateComponent;
import org.geolatte.geom.DimensionalFlag;
import org.geolatte.geom.PointCollection;
import org.geolatte.geom.PointCollectionPointEquality;
import org.geolatte.geom.PointSequence;

class NestedPointCollection
extends AbstractPointCollection
implements ComplexPointCollection {
    private final int size;
    protected final PointCollection[] children;

    NestedPointCollection(PointCollection[] children) {
        super(NestedPointCollection.extractDimensionalFlag(children));
        this.children = children;
        this.size = this.calculateSize();
    }

    private static DimensionalFlag extractDimensionalFlag(PointCollection[] children) {
        return children == null || children.length == 0 ? DimensionalFlag.XY : children[0].getDimensionalFlag();
    }

    private int calculateSize() {
        int size = 0;
        for (PointCollection child : this.getPointSets()) {
            size += child.size();
        }
        return size;
    }

    @Override
    public PointCollection[] getPointSets() {
        return this.children;
    }

    @Override
    public boolean isEmpty() {
        return this.children.length == 0;
    }

    @Override
    public double getCoordinate(int position, CoordinateComponent component) {
        int childOffset = position;
        for (PointCollection child : this.getPointSets()) {
            if (childOffset < child.size()) {
                return child.getCoordinate(childOffset, component);
            }
            childOffset -= child.size();
        }
        throw new ArrayIndexOutOfBoundsException(String.format("Index %d not found in collection of size %d", position, this.size()));
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public PointCollection clone() {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof PointSequence)) {
            return false;
        }
        PointSequence that = (PointSequence)o;
        if (this.is3D() != that.is3D()) {
            return false;
        }
        if (this.isMeasured() != that.isMeasured()) {
            return false;
        }
        return new PointCollectionPointEquality().equals(this, that);
    }

    public int hashCode() {
        return Arrays.hashCode(this.children);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (int i = 0; i < this.children.length; ++i) {
            if (i > 0) {
                builder.append(",");
            }
            builder.append(this.getPointSets()[i].toString());
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public Iterator<PointCollection> iterator() {
        return new Iterator<PointCollection>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < NestedPointCollection.this.children.length;
            }

            @Override
            public PointCollection next() {
                return NestedPointCollection.this.children[this.index++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove not supported on PointSets.");
            }
        };
    }
}

