/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import org.geolatte.geom.GeometryOperations;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.GeometryVisitor;
import org.geolatte.geom.LineString;
import org.geolatte.geom.PointSequence;
import org.geolatte.geom.crs.CrsId;

public class LinearRing
extends LineString {
    static final LinearRing EMPTY = new LinearRing(null, CrsId.UNDEFINED, null);

    public static LinearRing create(PointSequence points, CrsId crsId, GeometryOperations geometryOperations) {
        return new LinearRing(points, crsId, geometryOperations);
    }

    public static LinearRing createEmpty() {
        return EMPTY;
    }

    protected LinearRing(LineString lineString) {
        super(lineString);
        this.checkIsClosed();
    }

    public LinearRing(PointSequence points, CrsId crsId, GeometryOperations geometryOperations) {
        super(points, crsId, geometryOperations);
        this.checkIsClosed();
    }

    public LinearRing(PointSequence points, CrsId crsId) {
        this(points, crsId, null);
    }

    @Override
    public GeometryType getGeometryType() {
        return GeometryType.LINEAR_RING;
    }

    @Override
    public void accept(GeometryVisitor visitor) {
        visitor.visit(this);
    }

    private void checkIsClosed() {
        if (this.isEmpty() || this.isClosed() && this.getNumPoints() > 3) {
            return;
        }
        throw new IllegalArgumentException("Cannot create a LinearRing. PointSequence is not closed or contains < 4 points.");
    }
}

