/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import org.geolatte.geom.EmptyPointSequence;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryOperations;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.GeometryVisitor;
import org.geolatte.geom.Point;
import org.geolatte.geom.PointSequence;
import org.geolatte.geom.Points;
import org.geolatte.geom.crs.CrsId;

public class LineString
extends Geometry {
    static final LineString EMPTY = new LineString(null, CrsId.UNDEFINED, null);
    private final PointSequence points;

    public static LineString createEmpty() {
        return EMPTY;
    }

    protected LineString(LineString base) {
        super(base.getCrsId(), base.getGeometryOperations());
        this.points = base.points;
    }

    public LineString(PointSequence points, CrsId crsId, GeometryOperations geometryOperations) {
        super(crsId, geometryOperations);
        if (points == null) {
            points = EmptyPointSequence.INSTANCE;
        }
        this.points = points;
    }

    public LineString(PointSequence points, CrsId crsId) {
        this(points, crsId, null);
    }

    private boolean determineSimple() {
        return super.isSimple();
    }

    @Override
    public PointSequence getPoints() {
        return this.points;
    }

    public double getLength() {
        double length = 0.0;
        Point prev = null;
        for (Point pnt : this.getPoints()) {
            if (prev == null) {
                prev = pnt;
                continue;
            }
            length += Math.hypot(pnt.getX() - prev.getX(), pnt.getY() - prev.getY());
            prev = pnt;
        }
        return length;
    }

    public Point getStartPoint() {
        return this.isEmpty() ? Points.createEmpty() : this.getPointN(0);
    }

    public Point getEndPoint() {
        return this.isEmpty() ? Points.createEmpty() : this.getPointN(this.getNumPoints() - 1);
    }

    public boolean isClosed() {
        return !this.isEmpty() && this.getStartPoint().equals(this.getEndPoint());
    }

    public boolean isRing() {
        return !this.isEmpty() && this.isClosed() && this.isSimple();
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public GeometryType getGeometryType() {
        return GeometryType.LINE_STRING;
    }

    @Override
    public void accept(GeometryVisitor visitor) {
        visitor.visit(this);
    }
}

