/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.GeometryOperations;
import org.geolatte.geom.JTSGeometryOperations;
import org.geolatte.geom.LineString;
import org.geolatte.geom.LinearRing;
import org.geolatte.geom.MultiLineString;
import org.geolatte.geom.MultiPoint;
import org.geolatte.geom.MultiPolygon;
import org.geolatte.geom.Point;
import org.geolatte.geom.PointSequence;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.crs.CrsId;

public class GeometryFactory {
    private final CrsId crsId;
    private final GeometryOperations geometryOperations;

    public GeometryFactory(CrsId crsId, GeometryOperations geometryOperations) {
        this.crsId = crsId == null ? CrsId.UNDEFINED : crsId;
        this.geometryOperations = geometryOperations == null ? new JTSGeometryOperations() : geometryOperations;
    }

    public GeometryFactory(CrsId crsId) {
        this(crsId, null);
    }

    public GeometryFactory() {
        this(null, null);
    }

    public Point createPoint(PointSequence points) {
        return new Point(points, this.crsId, this.geometryOperations);
    }

    public LineString createLineString(PointSequence points) {
        return new LineString(points, this.crsId, this.geometryOperations);
    }

    public LinearRing createLinearRing(PointSequence points) {
        return LinearRing.create(points, this.crsId, this.geometryOperations);
    }

    public Polygon createPolygon(PointSequence points) {
        return new Polygon(new LinearRing[]{new LinearRing(points, this.crsId, this.geometryOperations)});
    }

    public Polygon createPolygon(LinearRing[] rings) {
        return new Polygon(rings);
    }

    public GeometryCollection createGeometryCollection(Geometry[] geometries) {
        return new GeometryCollection(geometries);
    }

    public MultiPoint createMultiPoint(Point[] points) {
        return new MultiPoint(points);
    }

    public MultiLineString createMultiLineString(LineString[] lineStrings) {
        return new MultiLineString(lineStrings);
    }

    public MultiPolygon createMultiPolygon(Polygon[] polygons) {
        return new MultiPolygon(polygons);
    }
}

