/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import java.util.Iterator;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.GeometryVisitor;
import org.geolatte.geom.PointCollection;
import org.geolatte.geom.crs.CrsId;

public class GeometryCollection
extends Geometry
implements Iterable<Geometry> {
    protected final Geometry[] geometries;
    protected final PointCollection points;
    static final GeometryCollection EMPTY = new GeometryCollection(new Geometry[0]);

    public static GeometryCollection createEmpty() {
        return EMPTY;
    }

    public GeometryCollection(Geometry[] geometries) {
        super(GeometryCollection.getCrsId(geometries), GeometryCollection.getGeometryOperations(geometries));
        this.check(geometries);
        this.points = GeometryCollection.collectPointSets(geometries);
        this.geometries = this.points.isEmpty() ? new Geometry[0] : geometries;
    }

    public int getNumGeometries() {
        return this.geometries.length;
    }

    public Geometry getGeometryN(int num) {
        return this.geometries[num];
    }

    @Override
    public int getDimension() {
        int maxDim = 0;
        for (Geometry part : this) {
            maxDim = Math.max(maxDim, part.getDimension());
        }
        return maxDim;
    }

    @Override
    public GeometryType getGeometryType() {
        return GeometryType.GEOMETRY_COLLECTION;
    }

    @Override
    public PointCollection getPoints() {
        return this.points;
    }

    @Override
    public Iterator<Geometry> iterator() {
        return new Iterator<Geometry>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < GeometryCollection.this.geometries.length;
            }

            @Override
            public Geometry next() {
                return GeometryCollection.this.geometries[this.index++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void accept(GeometryVisitor visitor) {
        visitor.visit(this);
        for (Geometry part : this) {
            part.accept(visitor);
        }
    }

    private void check(Geometry[] geometries) {
        if (geometries == null || geometries.length == 0) {
            return;
        }
        String msg = "NULL element not allowd in Geometry array";
        if (geometries[0] == null) {
            throw new IllegalStateException(msg);
        }
        CrsId crsId = geometries[0].getCrsId();
        for (int i = 1; i < geometries.length; ++i) {
            if (geometries[i] == null) {
                throw new IllegalStateException(msg);
            }
            if (crsId.equals(geometries[i].getCrsId())) continue;
            throw new IllegalStateException("Geometries in the array do no share the same coordinate reference systems.");
        }
    }
}

