/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import org.geolatte.geom.DimensionalFlag;
import org.geolatte.geom.Point;
import org.geolatte.geom.PointSequence;
import org.geolatte.geom.PointSequenceBuilder;

abstract class AbstractPointSequenceBuilder
implements PointSequenceBuilder {
    protected final DimensionalFlag dimensionalFlag;

    public AbstractPointSequenceBuilder(DimensionalFlag dimensionalFlag) {
        this.dimensionalFlag = dimensionalFlag;
    }

    @Override
    public PointSequenceBuilder add(double[] coordinates) {
        if (coordinates.length < this.dimensionalFlag.getCoordinateDimension()) {
            throw new IllegalArgumentException(String.format("Parameter must be array of getLength %d", this.dimensionalFlag.getCoordinateDimension()));
        }
        for (int i = 0; i < this.dimensionalFlag.getCoordinateDimension(); ++i) {
            this.add(coordinates[i]);
        }
        return this;
    }

    @Override
    public PointSequenceBuilder add(double x, double y) {
        if (this.dimensionalFlag != DimensionalFlag.XY) {
            throw new IllegalArgumentException("Attempting to add 2D point to pointsequence of dimension " + (Object)((Object)this.dimensionalFlag));
        }
        this.add(x);
        this.add(y);
        return this;
    }

    @Override
    public PointSequenceBuilder add(double x, double y, double zOrm) {
        if (this.dimensionalFlag != DimensionalFlag.XYZ && this.dimensionalFlag != DimensionalFlag.XYM) {
            throw new IllegalArgumentException("Attempting to add 3D point to pointsequence of dimension " + (Object)((Object)this.dimensionalFlag));
        }
        this.add(x);
        this.add(y);
        this.add(zOrm);
        return this;
    }

    @Override
    public PointSequenceBuilder add(double x, double y, double z, double m) {
        if (this.dimensionalFlag != DimensionalFlag.XYZM) {
            throw new IllegalArgumentException("Attempting to add 3D point to pointsequence of dimension " + (Object)((Object)this.dimensionalFlag));
        }
        this.add(x);
        this.add(y);
        this.add(z);
        this.add(m);
        return this;
    }

    @Override
    public PointSequenceBuilder add(Point point) {
        double[] coords;
        if (point.is3D() != this.dimensionalFlag.is3D() || point.isMeasured() != this.dimensionalFlag.isMeasured()) {
            throw new IllegalArgumentException("Attempting to add Point to pointsequence with inconsistent DimensionalFlag");
        }
        for (double coord : coords = this.getPointCoordinates(point)) {
            this.add(coord);
        }
        return this;
    }

    @Override
    public DimensionalFlag getDimensionalFlag() {
        return this.dimensionalFlag;
    }

    private double[] getPointCoordinates(Point point) {
        PointSequence points = point.getPoints();
        double[] coords = new double[this.dimensionalFlag.getCoordinateDimension()];
        points.getCoordinates(coords, 0);
        return coords;
    }

    protected abstract void add(double var1);
}

