/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.crs.CoordinateReferenceSystems;
import org.geolatte.geom.crs.CrsId;
import org.geolatte.geom.crs.CrsRegistry;
import org.geolatte.geom.json.CrsDeserializer;
import org.geolatte.geom.json.GeoJsonProcessingException;
import org.geolatte.geom.json.GeometryBuilder;
import org.geolatte.geom.json.Setting;
import org.geolatte.geom.json.Settings;

public class GeometryDeserializer
extends JsonDeserializer<Geometry<?>> {
    private final CoordinateReferenceSystem<?> defaultCRS;
    private final Settings settings;
    private final CrsDeserializer crsDeser;

    public GeometryDeserializer(CoordinateReferenceSystem<?> defaultCRS, Settings settings) {
        this.defaultCRS = defaultCRS;
        this.settings = settings;
        this.crsDeser = new CrsDeserializer(this.defaultCRS, settings);
    }

    private JsonNode getRoot(JsonParser p) throws IOException {
        ObjectCodec oc = p.getCodec();
        return (JsonNode)oc.readTree(p);
    }

    public Geometry<?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode root = this.getRoot(p);
        return this.parseGeometry(root);
    }

    Geometry<?> parseGeometry(JsonNode root) throws GeoJsonProcessingException {
        CoordinateReferenceSystem crs = this.resolveBaseCrs(root);
        GeometryBuilder parser = GeometryBuilder.create(root);
        CoordinateReferenceSystem adjustedCrs = this.settings.isSet(Setting.FORCE_DEFAULT_CRS_DIMENSION) ? crs : CoordinateReferenceSystems.adjustTo(crs, (int)parser.getCoordinateDimension());
        return parser.parse(adjustedCrs);
    }

    protected CoordinateReferenceSystem<?> getDefaultCrs() {
        return this.defaultCRS;
    }

    private CoordinateReferenceSystem<?> resolveBaseCrs(JsonNode root) throws GeoJsonProcessingException {
        CrsId id = this.getCrsId(root);
        return id.equals((Object)CrsId.UNDEFINED) || this.settings.isSet(Setting.FORCE_DEFAULT_CRS_DIMENSION) || this.settings.isSet(Setting.IGNORE_CRS) ? this.defaultCRS : CrsRegistry.getCoordinateReferenceSystemForEPSG((int)id.getCode(), this.getDefaultCrs());
    }

    protected CrsId getCrsId(JsonNode root) throws GeoJsonProcessingException {
        JsonNode crs = root.get("crs");
        return this.crsDeser.getCrsId(crs);
    }
}

