/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.json;

import com.fasterxml.jackson.databind.JsonNode;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.Position;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.json.GeoJsonProcessingException;
import org.geolatte.geom.json.GeometryCollectionBuilder;
import org.geolatte.geom.json.SimpleGeometryBuilder;

abstract class GeometryBuilder {
    GeometryBuilder() {
    }

    static GeometryBuilder create(JsonNode root) throws GeoJsonProcessingException {
        GeometryType type = GeometryBuilder.getType(root);
        if (type == GeometryType.GEOMETRYCOLLECTION) {
            return new GeometryCollectionBuilder(root);
        }
        return new SimpleGeometryBuilder(root);
    }

    abstract int getCoordinateDimension();

    abstract <P extends Position> Geometry<P> parse(CoordinateReferenceSystem<P> var1) throws GeoJsonProcessingException;

    static GeometryType getType(JsonNode root) throws GeoJsonProcessingException {
        String type = root.get("type").asText();
        try {
            return GeometryType.valueOf((String)type.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            throw new GeoJsonProcessingException(String.format("Can't parse GeoJson of type %s", type));
        }
    }
}

