/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.json;

import com.fasterxml.jackson.databind.JsonNode;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.Position;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.json.GeoJsonProcessingException;
import org.geolatte.geom.json.GeometryBuilder;
import org.geolatte.geom.json.Holder;
import org.geolatte.geom.json.LinearPositionsHolder;
import org.geolatte.geom.json.LinearPositionsListHolder;
import org.geolatte.geom.json.PointHolder;
import org.geolatte.geom.json.PolygonListHolder;

class SimpleGeometryBuilder
extends GeometryBuilder {
    private final GeometryType type;
    private final Holder coordinates;

    SimpleGeometryBuilder(JsonNode root) throws GeoJsonProcessingException {
        super(root);
        this.type = SimpleGeometryBuilder.getType(root);
        this.coordinates = this.toHolder(this.type, this.getCoordinates(root));
    }

    private JsonNode getCoordinates(JsonNode root) {
        return root.get("coordinates");
    }

    @Override
    int getCoordinateDimension() {
        return this.coordinates.getCoordinateDimension();
    }

    @Override
    <P extends Position> Geometry<P> parse(CoordinateReferenceSystem<P> crs) throws GeoJsonProcessingException {
        return this.coordinates.toGeometry(crs, this.type);
    }

    protected Holder toHolder(GeometryType geomType, JsonNode root) throws GeoJsonProcessingException {
        switch (geomType) {
            case POINT: {
                return this.toPointHolder(root);
            }
            case LINESTRING: {
                return this.toLinearPositionsHolder(root);
            }
            case POLYGON: {
                return this.toLinearPositionsListHolder(root);
            }
            case MULTIPOINT: {
                return this.toLinearPositionsHolder(root);
            }
            case MULTILINESTRING: {
                return this.toLinearPositionsListHolder(root);
            }
            case MULTIPOLYGON: {
                return this.toPolygonalListHolder(root);
            }
        }
        throw new GeoJsonProcessingException("Unsupported geometry type " + geomType.toString());
    }

    private PointHolder toPointHolder(JsonNode coordinates) throws GeoJsonProcessingException {
        if (!coordinates.isArray()) {
            throw new GeoJsonProcessingException("Parser expects coordinate as array");
        }
        if (coordinates.size() == 0) {
            return new PointHolder();
        }
        int coDim = coordinates.size();
        if (coDim < 2) {
            throw new GeoJsonProcessingException("Need at least 2 coordinate values in array");
        }
        double[] co = new double[coDim];
        for (int i = 0; i < coordinates.size() && i < coDim; ++i) {
            co[i] = coordinates.get(i).asDouble();
        }
        return new PointHolder(co);
    }

    private LinearPositionsHolder toLinearPositionsHolder(JsonNode coordinates) throws GeoJsonProcessingException {
        if (!coordinates.isArray()) {
            throw new GeoJsonProcessingException("Parser expects coordinate as array");
        }
        LinearPositionsHolder holder = new LinearPositionsHolder();
        for (int i = 0; i < coordinates.size(); ++i) {
            holder.push(this.toPointHolder(coordinates.get(i)));
        }
        return holder;
    }

    private LinearPositionsListHolder toLinearPositionsListHolder(JsonNode coordinates) throws GeoJsonProcessingException {
        if (!coordinates.isArray()) {
            throw new GeoJsonProcessingException("Parser expects coordinate as array");
        }
        LinearPositionsListHolder holder = new LinearPositionsListHolder();
        for (int i = 0; i < coordinates.size(); ++i) {
            holder.push(this.toLinearPositionsHolder(coordinates.get(i)));
        }
        return holder;
    }

    private PolygonListHolder toPolygonalListHolder(JsonNode coordinates) throws GeoJsonProcessingException {
        if (!coordinates.isArray()) {
            throw new GeoJsonProcessingException("Parser expects coordinate as array");
        }
        PolygonListHolder holder = new PolygonListHolder();
        for (int i = 0; i < coordinates.size(); ++i) {
            holder.push(this.toLinearPositionsListHolder(coordinates.get(i)));
        }
        return holder;
    }
}

