/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.json;

import java.util.Arrays;
import org.geolatte.geom.Geometries;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.Point;
import org.geolatte.geom.Position;
import org.geolatte.geom.Positions;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.json.Holder;

class PointHolder
extends Holder {
    private final double[] coordinates;

    public PointHolder() {
        this.coordinates = new double[0];
    }

    public PointHolder(double[] coordinates) {
        this.coordinates = coordinates;
    }

    public double[] getCoordinates() {
        return this.coordinates;
    }

    @Override
    boolean isEmpty() {
        return this.coordinates.length == 0;
    }

    @Override
    int getCoordinateDimension() {
        return this.coordinates.length;
    }

    public <P extends Position> P toPosition(CoordinateReferenceSystem<P> crs) {
        double[] co = this.getCoordinateDimension() != crs.getCoordinateDimension() ? this.toDimension(this.getCoordinates(), crs.getCoordinateDimension()) : this.getCoordinates();
        return (P)Positions.mkPosition((Class)crs.getPositionClass(), (double[])co);
    }

    <P extends Position> Point<P> toGeometry(CoordinateReferenceSystem<P> crs, GeometryType geomType) {
        if (this.isEmpty()) {
            return Geometries.mkEmptyPoint(crs);
        }
        return Geometries.mkPoint(this.toPosition(crs), crs);
    }

    private double[] toDimension(double[] orig, int targetDim) {
        return Arrays.copyOf(orig, targetDim);
    }
}

