/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.json;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.geolatte.geom.Geometries;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.LineString;
import org.geolatte.geom.LinearRing;
import org.geolatte.geom.Position;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.json.GeoJsonProcessingException;
import org.geolatte.geom.json.Holder;
import org.geolatte.geom.json.LinearPositionsHolder;

public class LinearPositionsListHolder
extends Holder {
    private final List<LinearPositionsHolder> spcs = new ArrayList<LinearPositionsHolder>();

    void push(LinearPositionsHolder lph) {
        this.spcs.add(lph);
    }

    @Override
    boolean isEmpty() {
        return this.spcs.isEmpty();
    }

    @Override
    int getCoordinateDimension() {
        return this.spcs.stream().mapToInt(Holder::getCoordinateDimension).max().orElse(0);
    }

    @Override
    <P extends Position> Geometry<P> toGeometry(CoordinateReferenceSystem<P> crs, GeometryType geomType) throws GeoJsonProcessingException {
        if (geomType == GeometryType.POLYGON) {
            if (this.isEmpty()) {
                return Geometries.mkEmptyPolygon(crs);
            }
            return Geometries.mkPolygon(this.toLinearRings(crs));
        }
        if (geomType == GeometryType.MULTILINESTRING) {
            if (this.isEmpty()) {
                return Geometries.mkEmptyMultiLineString(crs);
            }
            return Geometries.mkMultiLineString(this.toLineStrings(crs));
        }
        throw new GeoJsonProcessingException("Can't convert this coordinates array to requested Geomtype: " + geomType);
    }

    <P extends Position> List<LinearRing<P>> toLinearRings(CoordinateReferenceSystem<P> crs) {
        return this.spcs.stream().map(lph -> new LinearRing(lph.toPositionSequence(crs), crs)).collect(Collectors.toList());
    }

    <P extends Position> List<LineString<P>> toLineStrings(CoordinateReferenceSystem<P> crs) {
        return this.spcs.stream().map(lph -> new LineString(lph.toPositionSequence(crs), crs)).collect(Collectors.toList());
    }
}

