/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.geolatte.geom.Position;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.json.Setting;
import org.geolatte.geom.json.Settings;

public class CrsSerializer<P extends Position>
extends JsonSerializer<CoordinateReferenceSystem<P>> {
    private final CoordinateReferenceSystem<P> defaultCRS;
    private final Settings settings;

    public CrsSerializer(CoordinateReferenceSystem<P> defaultCRS, Settings settings) {
        this.defaultCRS = defaultCRS;
        this.settings = settings;
    }

    public void serialize(CoordinateReferenceSystem<P> crs, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        this.writeCrs(gen, crs);
    }

    private void writeCrs(JsonGenerator gen, CoordinateReferenceSystem<P> crs) throws IOException {
        this.writeNamedCrs(gen, crs);
    }

    private void writeNamedCrs(JsonGenerator gen, CoordinateReferenceSystem<P> crs) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("type", "name");
        gen.writeFieldName("properties");
        if (this.settings.isSet(Setting.SERIALIZE_CRS_AS_URN)) {
            this.writeCrsName(gen, crs.getCrsId().toUrn());
        } else {
            this.writeCrsName(gen, crs.getCrsId().toString());
        }
        gen.writeEndObject();
    }

    private void writeCrsName(JsonGenerator gen, String epsgString) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("name", epsgString);
        gen.writeEndObject();
    }
}

