/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.json;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.geolatte.geom.Geometries;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.Position;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.json.GeoJsonProcessingException;
import org.geolatte.geom.json.Holder;
import org.geolatte.geom.json.LinearPositionsListHolder;

class PolygonListHolder
extends Holder {
    private final List<LinearPositionsListHolder> spcs = new ArrayList<LinearPositionsListHolder>();

    PolygonListHolder() {
    }

    void push(LinearPositionsListHolder lph) {
        this.spcs.add(lph);
    }

    @Override
    boolean isEmpty() {
        return this.spcs.isEmpty();
    }

    @Override
    int getCoordinateDimension() {
        return this.spcs.stream().mapToInt(Holder::getCoordinateDimension).max().orElse(0);
    }

    @Override
    <P extends Position> Geometry<P> toGeometry(CoordinateReferenceSystem<P> crs, GeometryType geomType) throws GeoJsonProcessingException {
        return this.isEmpty() ? Geometries.mkEmptyMultiPolygon(crs) : Geometries.mkMultiPolygon(this.toPolygons(crs));
    }

    <P extends Position> List<Polygon<P>> toPolygons(CoordinateReferenceSystem<P> crs) {
        return this.spcs.stream().map(lph -> lph.isEmpty() ? Geometries.mkEmptyPolygon((CoordinateReferenceSystem)crs) : Geometries.mkPolygon(lph.toLinearRings(crs))).collect(Collectors.toList());
    }
}

