/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.json;

import java.util.ArrayList;
import java.util.List;
import org.geolatte.geom.Geometries;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.Position;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.PositionSequenceBuilder;
import org.geolatte.geom.PositionSequenceBuilders;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.json.GeoJsonProcessingException;
import org.geolatte.geom.json.Holder;
import org.geolatte.geom.json.PointHolder;

class LinearPositionsHolder
extends Holder {
    private final List<PointHolder> spcs = new ArrayList<PointHolder>();

    LinearPositionsHolder() {
    }

    void push(PointHolder holder) {
        this.spcs.add(holder);
    }

    @Override
    boolean isEmpty() {
        return this.spcs.isEmpty();
    }

    @Override
    int getCoordinateDimension() {
        return this.spcs.stream().mapToInt(Holder::getCoordinateDimension).max().orElse(0);
    }

    @Override
    <P extends Position> Geometry<P> toGeometry(CoordinateReferenceSystem<P> crs, GeometryType geomType) throws GeoJsonProcessingException {
        if (geomType == GeometryType.LINESTRING) {
            return this.isEmpty() ? Geometries.mkEmptyLineString(crs) : Geometries.mkLineString(this.toPositionSequence(crs), crs);
        }
        if (geomType == GeometryType.MULTIPOINT) {
            return this.isEmpty() ? Geometries.mkEmptyMultiPoint(crs) : Geometries.mkMultiPoint(this.toPositionSequence(crs), crs);
        }
        throw new GeoJsonProcessingException("Can't convert this coordinates array to requested Geomtype: " + geomType);
    }

    <P extends Position> PositionSequence<P> toPositionSequence(CoordinateReferenceSystem<P> crs) {
        PositionSequenceBuilder builder = PositionSequenceBuilders.fixedSized((int)this.spcs.size(), (Class)crs.getPositionClass());
        this.spcs.forEach(h -> builder.add(h.toPosition(crs)));
        return builder.toPositionSequence();
    }
}

