/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.crs.CoordinateReferenceSystems;
import org.geolatte.geom.crs.CrsId;
import org.geolatte.geom.crs.CrsRegistry;
import org.geolatte.geom.crs.LinearUnit;
import org.geolatte.geom.crs.Unit;
import org.geolatte.geom.json.GeoJsonProcessingException;
import org.geolatte.geom.json.GeometryBuilder;
import org.geolatte.geom.json.Setting;
import org.geolatte.geom.json.Settings;

public class GeometryDeserializer
extends JsonDeserializer<Geometry> {
    private final CoordinateReferenceSystem<?> defaultCRS;
    private final Settings settings;

    public GeometryDeserializer(CoordinateReferenceSystem<?> defaultCRS, Settings settings) {
        this.defaultCRS = defaultCRS;
        this.settings = settings;
    }

    private JsonNode getRoot(JsonParser p) throws IOException, GeoJsonProcessingException {
        ObjectCodec oc = p.getCodec();
        return (JsonNode)oc.readTree(p);
    }

    public Geometry<?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode root = this.getRoot(p);
        return this.parseGeometry(root);
    }

    Geometry<?> parseGeometry(JsonNode root) throws GeoJsonProcessingException {
        CoordinateReferenceSystem<?> crs = this.resolveBaseCrs(root);
        GeometryBuilder parser = GeometryBuilder.create(root);
        CoordinateReferenceSystem<?> adjustedCrs = this.adjustTo(crs, parser.getCoordinateDimension());
        return parser.parse(adjustedCrs);
    }

    protected CoordinateReferenceSystem<?> getDefaultCrs() {
        return this.defaultCRS;
    }

    private CoordinateReferenceSystem<?> adjustTo(CoordinateReferenceSystem<?> crs, int coordinateDimension) throws GeoJsonProcessingException {
        if (this.settings.isSet(Setting.FORCE_DEFAULT_CRS_DIMENSION)) {
            return crs;
        }
        if (coordinateDimension <= 2) {
            return crs;
        }
        if (coordinateDimension == 3) {
            CrsId extId = crs.getCrsId().extend(Unit.METER, null);
            return CrsRegistry.computeIfAbsent((CrsId)extId, key -> CoordinateReferenceSystems.mkCoordinateReferenceSystem((CoordinateReferenceSystem)crs, (LinearUnit)Unit.METER, null));
        }
        if (coordinateDimension == 4) {
            CrsId extId = crs.getCrsId().extend(Unit.METER, (Unit)Unit.METER);
            return CrsRegistry.computeIfAbsent((CrsId)extId, key -> CoordinateReferenceSystems.mkCoordinateReferenceSystem((CoordinateReferenceSystem)crs, (LinearUnit)Unit.METER, (LinearUnit)Unit.METER));
        }
        throw new GeoJsonProcessingException("CoordinateDimension " + coordinateDimension + " less than 2 or larger than 4");
    }

    private CoordinateReferenceSystem<?> resolveBaseCrs(JsonNode root) throws GeoJsonProcessingException {
        CrsId id = this.getCrsId(root);
        return id.equals((Object)CrsId.UNDEFINED) || this.settings.isSet(Setting.FORCE_DEFAULT_CRS_DIMENSION) ? this.defaultCRS : CrsRegistry.getCoordinateReferenceSystemForEPSG((int)id.getCode(), this.getDefaultCrs());
    }

    protected CrsId getCrsId(JsonNode root) throws GeoJsonProcessingException {
        JsonNode crs = root.get("crs");
        if (crs == null) {
            return CrsId.UNDEFINED;
        }
        String type = crs.get("type").asText();
        if (!type.equalsIgnoreCase("name")) {
            throw new GeoJsonProcessingException("Can parse only named crs elements");
        }
        String text = crs.get("properties").get("name").asText();
        return CrsId.parse((String)text);
    }
}

