/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.json;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.geolatte.geom.Geometries;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.Position;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.json.GeoJsonProcessingException;
import org.geolatte.geom.json.GeometryBuilder;

class GeometryCollectionBuilder
extends GeometryBuilder {
    private final List<GeometryBuilder> components = new ArrayList<GeometryBuilder>();

    GeometryCollectionBuilder(JsonNode root) throws GeoJsonProcessingException {
        super(root);
        JsonNode geometriesNode = root.get("geometries");
        for (int i = 0; i < geometriesNode.size(); ++i) {
            this.components.add(GeometryBuilder.create(geometriesNode.get(i)));
        }
    }

    @Override
    int getCoordinateDimension() {
        return this.components.stream().map(GeometryBuilder::getCoordinateDimension).filter(d -> d > 0).findFirst().orElse(2);
    }

    @Override
    <P extends Position> Geometry<P> parse(CoordinateReferenceSystem<P> crs) throws GeoJsonProcessingException {
        List collect;
        try {
            collect = this.components.stream().map(b -> this.toComponentGeom(crs, (GeometryBuilder)b)).collect(Collectors.toList());
        }
        catch (RuntimeException e) {
            throw new GeoJsonProcessingException(e.getMessage());
        }
        return collect.isEmpty() ? Geometries.mkEmptyGeometryCollection(crs) : Geometries.mkGeometryCollection(collect);
    }

    private <P extends Position> Geometry<P> toComponentGeom(CoordinateReferenceSystem<P> crs, GeometryBuilder b) {
        try {
            return b.parse(crs);
        }
        catch (GeoJsonProcessingException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }
}

