/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.HashMap;
import org.geolatte.geom.Feature;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.json.GeoJsonFeature;
import org.geolatte.geom.json.GeometryDeserializer;
import org.geolatte.geom.json.Settings;

public class FeatureDeserializer
extends JsonDeserializer<Feature> {
    private final CoordinateReferenceSystem<?> defaultCrs;
    private final Settings settings;
    private final GeometryDeserializer geomParser;

    public FeatureDeserializer(CoordinateReferenceSystem<?> defaultCrs, Settings settings) {
        this.defaultCrs = defaultCrs;
        this.settings = settings;
        this.geomParser = new GeometryDeserializer(defaultCrs, settings);
    }

    public Feature<?, ?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectCodec oc = p.getCodec();
        JsonNode root = (JsonNode)oc.readTree(p);
        JsonNode geomNode = root.get("geometry");
        Geometry<?> geom = this.geomParser.parseGeometry(geomNode);
        Object id = null;
        JsonNode idNode = root.get("id");
        id = idNode.canConvertToLong() ? Long.valueOf(idNode.asLong()) : idNode.asText();
        HashMap properties = (HashMap)oc.treeToValue((TreeNode)root.get("properties"), HashMap.class);
        return new GeoJsonFeature(geom, id, properties);
    }
}

