/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.vorbis.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gagravarr.vorbis.VorbisAudioData;
import org.gagravarr.vorbis.VorbisFile;

public class VorbisCommentTool {
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            VorbisCommentTool.printHelp();
        }
        if (args.length == 1) {
            VorbisCommentTool.listTags(args[0]);
            return;
        }
        if (args.length == 2 && args[0].equals("-l")) {
            VorbisCommentTool.listTags(args[1]);
            return;
        }
        if (args[0].equals("-w")) {
            VorbisCommentTool.editTags(false, args);
            return;
        }
        if (args[0].equals("-a")) {
            VorbisCommentTool.editTags(true, args);
            return;
        }
        VorbisCommentTool.printHelp();
    }

    public static void printHelp() {
        System.err.println("Use:");
        System.err.println("  VorbisCommentTool [-l] file.ogg");
        System.err.println("  VorbisCommentTool -a [-t name=value] [-t name=value] in.ogg [out.ogg]");
        System.err.println("  VorbisCommentTool -w [-t name=value] [-t name=value] in.ogg [out.ogg]");
        System.exit(1);
    }

    public static void listTags(String filename) throws Exception {
        VorbisFile vf = new VorbisFile(new File(filename));
        Map comments = vf.getComment().getAllComments();
        for (String tag : comments.keySet()) {
            for (String value : (List)comments.get(tag)) {
                System.out.println(tag + "=" + value);
            }
        }
    }

    public static void editTags(boolean append, String[] args) throws Exception {
        VorbisAudioData ad;
        String outFile;
        String inFile = outFile = args[args.length - 1];
        if (args.length % 2 == 1) {
            inFile = args[args.length - 2];
        }
        System.out.println("Source file: " + inFile);
        System.out.println("Output file: " + outFile);
        VorbisFile in = new VorbisFile(new File(inFile));
        if (!append) {
            in.getComment().removeAllComments();
        }
        for (int i = 1; i < args.length - 2; i += 2) {
            if (!"-t".equals(args[i])) {
                throw new IllegalArgumentException("Expecting '-t name=value' but found '" + args[i] + " " + args[i + 1] + "'");
            }
            int split = args[i + 1].indexOf(61);
            String name = args[i + 1].substring(0, split);
            String value = args[i + 1].substring(split + 1);
            System.out.println("   Setting '" + name + " = " + value + "'");
            in.getComment().addComment(name, value);
        }
        ArrayList<VorbisAudioData> audio = new ArrayList<VorbisAudioData>();
        while ((ad = in.getNextAudioPacket()) != null) {
            audio.add(ad);
        }
        in.close();
        VorbisFile out = new VorbisFile((OutputStream)new FileOutputStream(outFile), in.getSid(), in.getInfo(), in.getComment(), in.getSetup());
        for (VorbisAudioData vad : audio) {
            out.writeAudioData(vad);
        }
        out.close();
    }
}

