/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.tika;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.XMPDM;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.gagravarr.flac.FlacFile;
import org.gagravarr.flac.FlacInfo;
import org.gagravarr.flac.FlacOggFile;
import org.gagravarr.ogg.OggStreamIdentifier;
import org.gagravarr.tika.VorbisParser;
import org.gagravarr.vorbis.VorbisStyleComments;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlacParser
extends AbstractParser {
    private static final long serialVersionUID = -7546577301474546694L;
    protected static final MediaType NATIVE_FLAC = MediaType.parse((String)OggStreamIdentifier.NATIVE_FLAC.mimetype);
    protected static final MediaType OGG_FLAC = MediaType.parse((String)OggStreamIdentifier.OGG_FLAC.mimetype);
    private static List<MediaType> TYPES = Arrays.asList(NATIVE_FLAC, OGG_FLAC);

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return new HashSet<MediaType>(TYPES);
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, TikaException, SAXException {
        metadata.set(XMPDM.AUDIO_COMPRESSOR, "FLAC");
        FlacFile flac = FlacFile.open((InputStream)stream);
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        this.extractInfo(metadata, flac.getInfo());
        if (flac instanceof FlacOggFile) {
            FlacOggFile ogg = (FlacOggFile)flac;
            metadata.add("version", "Flac " + ogg.getFirstPacket().getMajorVersion() + "." + ogg.getFirstPacket().getMinorVersion());
            metadata.set("Content-Type", OGG_FLAC.toString());
        } else {
            metadata.set("Content-Type", NATIVE_FLAC.toString());
        }
        VorbisParser.extractComments(metadata, xhtml, (VorbisStyleComments)flac.getTags());
        xhtml.endDocument();
        flac.close();
    }

    protected void extractInfo(Metadata metadata, FlacInfo info) throws TikaException {
        metadata.set(XMPDM.AUDIO_SAMPLE_RATE, info.getSampleRate());
        VorbisParser.extractChannelInfo(metadata, info.getNumChannels());
    }
}

