/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.util;

import java.util.ArrayList;
import net.sf.retrotranslator.runtime.java.lang.ThreadLocal_;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ThreadLocalPool<T> {
    private final ThreadLocal_<Pool> objectsThreadLocal = new ThreadLocal_();

    protected abstract T create();

    protected int maxPoolSizePerThread() {
        return 10;
    }

    private Pool getPool() {
        Pool rc = (Pool)this.objectsThreadLocal.get();
        if (rc == null) {
            rc = new Pool();
            this.objectsThreadLocal.set((Object)rc);
        }
        return rc;
    }

    public T checkout() {
        Pool pool = this.getPool();
        ArrayList objects = pool.objects;
        if (!objects.isEmpty()) {
            ++pool.hitCounter;
            return objects.remove(objects.size() - 1);
        }
        ++pool.missCounter;
        return this.create();
    }

    public void checkin(T value) {
        ArrayList objects = this.getPool().objects;
        if (objects.size() < this.maxPoolSizePerThread()) {
            objects.add(value);
        }
    }

    class Pool {
        final ArrayList<T> objects;
        long hitCounter;
        long missCounter;

        Pool() {
            this.objects = new ArrayList(ThreadLocalPool.this.maxPoolSizePerThread());
        }
    }
}

