/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.runtime.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.sf.retrotranslator.runtime.asm.AnnotationVisitor;
import net.sf.retrotranslator.runtime.asm.signature.SignatureReader;
import net.sf.retrotranslator.runtime.asm.signature.SignatureVisitor;
import net.sf.retrotranslator.runtime.impl.AnnotationArray;
import net.sf.retrotranslator.runtime.impl.AnnotationValue;
import net.sf.retrotranslator.runtime.impl.ClassDescriptor;
import net.sf.retrotranslator.runtime.impl.EnumValue;
import net.sf.retrotranslator.runtime.impl.GenericDeclarationDescriptor;
import net.sf.retrotranslator.runtime.impl.LazyList;
import net.sf.retrotranslator.runtime.impl.LazyValue;
import net.sf.retrotranslator.runtime.impl.TypeDescriptor;
import net.sf.retrotranslator.runtime.java.lang.annotation.Annotation_;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodDescriptor
extends GenericDeclarationDescriptor {
    private String name;
    private String desc;
    private ClassDescriptor classDescriptor;
    private LazyValue<Class, Method> method;
    private LazyValue<String, Class> returnType;
    private LazyValue<Object, Object> defaultValue;
    private LazyValue<Class, Constructor> constructor;
    private LazyValue<TypeDescriptor, Object> genericReturnType;
    private LazyList<TypeDescriptor, Object> genericParameterTypes;
    private LazyList<TypeDescriptor, Object> genericExceptionTypes;
    private LazyList<List<AnnotationValue>, Annotation_[]> parameterAnnotations;
    private boolean metadataPresent;

    public MethodDescriptor(ClassDescriptor classDescriptor, int access, String name, String desc, String signature) {
        this.classDescriptor = classDescriptor;
        this.access = access;
        this.name = name;
        this.desc = desc;
        if (signature != null) {
            new SignatureReader(signature).accept(this);
        }
        this.returnType = this.createReturnType();
        if (name.equals("<init>")) {
            this.constructor = this.createConstructor();
        } else if (!name.equals("<clinit>")) {
            this.method = this.createMethod();
        }
        this.parameterAnnotations = this.createParameterAnnotations();
    }

    public boolean isMetadataPresent() {
        return this.metadataPresent;
    }

    private LazyValue<String, Class> createReturnType() {
        return new LazyValue<String, Class>(this.desc){};
    }

    private LazyValue<Class, Constructor> createConstructor() {
        return new LazyValue<Class, Constructor>(this.classDescriptor.getTarget()){};
    }

    private LazyValue<Class, Method> createMethod() {
        return new LazyValue<Class, Method>(this.classDescriptor.getTarget()){};
    }

    @Override
    public ClassDescriptor getClassDescriptor() {
        return this.classDescriptor;
    }

    private LazyList<List<AnnotationValue>, Annotation_[]> createParameterAnnotations() {
        return new LazyList<List<AnnotationValue>, Annotation_[]>(){};
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        if (name.equals("setEncodedMetadata") && this.name.equals("<clinit>")) {
            this.metadataPresent = true;
        }
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        if (!visible) {
            return EMPTY_VISITOR;
        }
        List<AnnotationValue> values = this.parameterAnnotations.get(parameter);
        if (values == null) {
            values = new ArrayList<AnnotationValue>();
            this.parameterAnnotations.set(parameter, values);
        }
        AnnotationValue value = new AnnotationValue(desc);
        values.add(value);
        return value;
    }

    @Override
    public void visit(String name, Object value) {
        this.setDefaultValue(value);
    }

    @Override
    public void visitEnum(String name, String desc, String value) {
        this.setDefaultValue(new EnumValue(desc, value));
    }

    @Override
    public AnnotationVisitor visitAnnotation(String name, String desc) {
        AnnotationValue value = new AnnotationValue(desc);
        this.setDefaultValue(value);
        return value;
    }

    @Override
    public AnnotationVisitor visitArray(String name) {
        AnnotationArray array = new AnnotationArray();
        this.setDefaultValue(array);
        return array;
    }

    @Override
    public SignatureVisitor visitParameterType() {
        TypeDescriptor descriptor = new TypeDescriptor();
        if (this.genericParameterTypes == null) {
            this.genericParameterTypes = this.getLazyList();
        }
        this.genericParameterTypes.add(descriptor);
        return descriptor;
    }

    @Override
    public SignatureVisitor visitReturnType() {
        TypeDescriptor descriptor = new TypeDescriptor();
        this.genericReturnType = this.getLazyType(descriptor);
        return descriptor;
    }

    @Override
    public SignatureVisitor visitExceptionType() {
        TypeDescriptor descriptor = new TypeDescriptor();
        if (this.genericExceptionTypes == null) {
            this.genericExceptionTypes = this.getLazyList();
        }
        this.genericExceptionTypes.add(descriptor);
        return descriptor;
    }

    private void setDefaultValue(Object o) {
        this.defaultValue = new LazyValue<Object, Object>(o){};
    }
}

