/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mqtt.cli;

import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.LinkedList;
import net.sf.retrotranslator.runtime.java.lang._Thread;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.ByteArrayOutputStream;
import org.fusesource.hawtbuf.UTF8Buffer;
import org.fusesource.hawtdispatch.Task;
import org.fusesource.mqtt.client.Callback;
import org.fusesource.mqtt.client.CallbackConnection;
import org.fusesource.mqtt.client.Listener;
import org.fusesource.mqtt.client.MQTT;
import org.fusesource.mqtt.client.QoS;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Publisher {
    private final MQTT mqtt = new MQTT();
    private QoS qos = QoS.AT_MOST_ONCE;
    private UTF8Buffer topic;
    private Buffer body;
    private boolean debug;
    private boolean retain;
    private long count = 1L;
    private long sleep;
    private boolean prefixCounter;

    private static void displayHelpAndExit(int exitCode) {
        Publisher.stdout("");
        Publisher.stdout("This is a simple mqtt client that will publish to a topic.");
        Publisher.stdout("");
        Publisher.stdout("Arguments: [-h host] [-k keepalive] [-c] [-i id] [-u username [-p password]]");
        Publisher.stdout("           [--will-topic topic [--will-payload payload] [--will-qos qos] [--will-retain]]");
        Publisher.stdout("           [-d] [-n count] [-s sleep] [-q qos] [-r] -t topic ( -pc | -m message | -z | -f file )");
        Publisher.stdout("");
        Publisher.stdout("");
        Publisher.stdout(" -h : mqtt host uri to connect to. Defaults to tcp://localhost:1883.");
        Publisher.stdout(" -k : keep alive in seconds for this client. Defaults to 60.");
        Publisher.stdout(" -c : disable 'clean session'.");
        Publisher.stdout(" -i : id to use for this client. Defaults to a random id.");
        Publisher.stdout(" -u : provide a username (requires MQTT 3.1 broker)");
        Publisher.stdout(" -p : provide a password (requires MQTT 3.1 broker)");
        Publisher.stdout(" --will-topic : the topic on which to publish the client Will.");
        Publisher.stdout(" --will-payload : payload for the client Will, which is sent by the broker in case of");
        Publisher.stdout("                  unexpected disconnection. If not given and will-topic is set, a zero");
        Publisher.stdout("                  length message will be sent.");
        Publisher.stdout(" --will-qos : QoS level for the client Will.");
        Publisher.stdout(" --will-retain : if given, make the client Will retained.");
        Publisher.stdout(" -d : display debug info on stderr");
        Publisher.stdout(" -n : the number of times to publish the message");
        Publisher.stdout(" -s : the number of milliseconds to sleep between publish operations (defaut: 0)");
        Publisher.stdout(" -q : quality of service level to use for the publish. Defaults to 0.");
        Publisher.stdout(" -r : message should be retained.");
        Publisher.stdout(" -t : mqtt topic to publish to.");
        Publisher.stdout(" -m : message payload to send.");
        Publisher.stdout(" -z : send a null (zero length) message.");
        Publisher.stdout(" -f : send the contents of a file as the message.");
        Publisher.stdout(" -pc : prefix a message counter to the message");
        Publisher.stdout("");
        System.exit(exitCode);
    }

    private static void stdout(Object x) {
        System.out.println(x);
    }

    private static void stderr(Object x) {
        System.err.println(x);
    }

    private static String shift(LinkedList<String> argl) {
        if (argl.isEmpty()) {
            Publisher.stderr("Invalid usage: Missing argument");
            Publisher.displayHelpAndExit(1);
        }
        return argl.removeFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws Exception {
        Publisher publisher = new Publisher();
        LinkedList<String> linkedList = new LinkedList<String>(Arrays.asList(stringArray));
        while (!linkedList.isEmpty()) {
            try {
                int n;
                String string = linkedList.removeFirst();
                if ("--help".equals(string)) {
                    Publisher.displayHelpAndExit(0);
                    continue;
                }
                if ("-h".equals(string)) {
                    publisher.mqtt.setHost(Publisher.shift(linkedList));
                    continue;
                }
                if ("-k".equals(string)) {
                    publisher.mqtt.setKeepAlive(Short.parseShort(Publisher.shift(linkedList)));
                    continue;
                }
                if ("-c".equals(string)) {
                    publisher.mqtt.setCleanSession(false);
                    continue;
                }
                if ("-i".equals(string)) {
                    publisher.mqtt.setClientId(Publisher.shift(linkedList));
                    continue;
                }
                if ("-u".equals(string)) {
                    publisher.mqtt.setUserName(Publisher.shift(linkedList));
                    continue;
                }
                if ("-p".equals(string)) {
                    publisher.mqtt.setPassword(Publisher.shift(linkedList));
                    continue;
                }
                if ("--will-topic".equals(string)) {
                    publisher.mqtt.setWillTopic(Publisher.shift(linkedList));
                    continue;
                }
                if ("--will-payload".equals(string)) {
                    publisher.mqtt.setWillMessage(Publisher.shift(linkedList));
                    continue;
                }
                if ("--will-qos".equals(string)) {
                    n = Integer.parseInt(Publisher.shift(linkedList));
                    if (n > QoS.values().length) {
                        Publisher.stderr(new StringBuffer().append("Invalid qos value : ").append(n).toString());
                        Publisher.displayHelpAndExit(1);
                    }
                    publisher.mqtt.setWillQos(QoS.values()[n]);
                    continue;
                }
                if ("--will-retain".equals(string)) {
                    publisher.mqtt.setWillRetain(true);
                    continue;
                }
                if ("-d".equals(string)) {
                    publisher.debug = true;
                    continue;
                }
                if ("-n".equals(string)) {
                    publisher.count = Long.parseLong(Publisher.shift(linkedList));
                    continue;
                }
                if ("-s".equals(string)) {
                    publisher.sleep = Long.parseLong(Publisher.shift(linkedList));
                    continue;
                }
                if ("-q".equals(string)) {
                    n = Integer.parseInt(Publisher.shift(linkedList));
                    if (n > QoS.values().length) {
                        Publisher.stderr(new StringBuffer().append("Invalid qos value : ").append(n).toString());
                        Publisher.displayHelpAndExit(1);
                    }
                    publisher.qos = QoS.values()[n];
                    continue;
                }
                if ("-r".equals(string)) {
                    publisher.retain = true;
                    continue;
                }
                if ("-t".equals(string)) {
                    publisher.topic = new UTF8Buffer(Publisher.shift(linkedList));
                    continue;
                }
                if ("-m".equals(string)) {
                    publisher.body = new UTF8Buffer(new StringBuffer().append(Publisher.shift(linkedList)).append("\n").toString());
                    continue;
                }
                if ("-z".equals(string)) {
                    publisher.body = new UTF8Buffer("");
                    continue;
                }
                if ("-f".equals(string)) {
                    File file = new File(Publisher.shift(linkedList));
                    RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
                    try {
                        byte[] byArray = new byte[(int)randomAccessFile.length()];
                        randomAccessFile.seek(0L);
                        randomAccessFile.readFully(byArray);
                        publisher.body = new Buffer(byArray);
                        continue;
                    }
                    finally {
                        randomAccessFile.close();
                        continue;
                    }
                }
                if ("-pc".equals(string)) {
                    publisher.prefixCounter = true;
                    continue;
                }
                Publisher.stderr(new StringBuffer().append("Invalid usage: unknown option: ").append(string).toString());
                Publisher.displayHelpAndExit(1);
            }
            catch (NumberFormatException numberFormatException) {
                Publisher.stderr("Invalid usage: argument not a number");
                Publisher.displayHelpAndExit(1);
            }
        }
        if (publisher.topic == null) {
            Publisher.stderr("Invalid usage: no topic specified.");
            Publisher.displayHelpAndExit(1);
        }
        if (publisher.body == null) {
            Publisher.stderr("Invalid usage: -z -m or -f must be specified.");
            Publisher.displayHelpAndExit(1);
        }
        publisher.execute();
        System.exit(0);
    }

    private void execute() {
        final CallbackConnection connection = this.mqtt.callbackConnection();
        final CountDownLatch done = new CountDownLatch(1);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                try {
                    this.setName("MQTT client shutdown");
                    connection.getDispatchQueue().execute(new Task(){

                        public void run() {
                            connection.disconnect(new Callback<Void>(){

                                @Override
                                public void onSuccess(Void value) {
                                    done.countDown();
                                }

                                @Override
                                public void onFailure(Throwable value) {
                                    done.countDown();
                                }

                                @Override
                                public /* synthetic */ void onSuccess(Object x0) {
                                    this.onSuccess((Void)x0);
                                }
                            });
                        }
                    });
                    return;
                }
                catch (Throwable throwable) {
                    _Thread.handleUncaughtException(throwable);
                    return;
                }
            }
        });
        connection.listener(new Listener(){

            public void onConnected() {
                if (Publisher.this.debug) {
                    Publisher.stderr("Connected");
                }
            }

            public void onDisconnected() {
                if (Publisher.this.debug) {
                    Publisher.stderr("Disconnected");
                }
            }

            public void onPublish(UTF8Buffer topic, Buffer body, Runnable ack) {
            }

            public void onFailure(Throwable value) {
                if (Publisher.this.debug) {
                    value.printStackTrace();
                } else {
                    Publisher.stderr(value);
                }
                System.exit(2);
            }
        });
        connection.resume();
        connection.connect(new Callback<Void>(){

            @Override
            public void onFailure(Throwable value) {
                if (Publisher.this.debug) {
                    value.printStackTrace();
                } else {
                    Publisher.stderr(value);
                }
                System.exit(2);
            }

            @Override
            public void onSuccess(Void value) {
            }

            @Override
            public /* synthetic */ void onSuccess(Object x0) {
                this.onSuccess((Void)x0);
            }
        });
        new Task(){
            long sent = 0L;

            public void run() {
                final 4 publish = this;
                Buffer message = Publisher.this.body;
                if (Publisher.this.prefixCounter) {
                    long id = this.sent + 1L;
                    ByteArrayOutputStream os = new ByteArrayOutputStream(message.length + 15);
                    os.write(new AsciiBuffer(Long.toString(id)));
                    os.write(58);
                    os.write(Publisher.this.body);
                    message = os.toBuffer();
                }
                connection.publish(Publisher.this.topic, message, Publisher.this.qos, Publisher.this.retain, new Callback<Void>(){

                    @Override
                    public void onSuccess(Void value) {
                        ++sent;
                        if (Publisher.this.debug) {
                            Publisher.stdout(new StringBuffer().append("Sent message #").append(sent).toString());
                        }
                        if (sent < Publisher.this.count) {
                            if (Publisher.this.sleep > 0L) {
                                System.out.println("Sleeping");
                                connection.getDispatchQueue().executeAfter(Publisher.this.sleep, TimeUnit.MILLISECONDS, publish);
                            } else {
                                connection.getDispatchQueue().execute(publish);
                            }
                        } else {
                            connection.disconnect(new Callback<Void>(){

                                @Override
                                public void onSuccess(Void value) {
                                    done.countDown();
                                }

                                @Override
                                public void onFailure(Throwable value) {
                                    done.countDown();
                                }

                                @Override
                                public /* synthetic */ void onSuccess(Object x0) {
                                    this.onSuccess((Void)x0);
                                }
                            });
                        }
                    }

                    @Override
                    public void onFailure(Throwable value) {
                        Publisher.stderr(new StringBuffer().append("Publish failed: ").append(value).toString());
                        if (Publisher.this.debug) {
                            value.printStackTrace();
                        }
                        System.exit(2);
                    }

                    @Override
                    public /* synthetic */ void onSuccess(Object x0) {
                        this.onSuccess((Void)x0);
                    }
                });
            }
        }.run();
        try {
            done.await();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }
}

