/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mqtt.client;

import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import edu.emory.mathcs.backport.java.util.concurrent.SynchronousQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.net.URI;
import java.net.URISyntaxException;
import javax.net.ssl.SSLContext;
import net.sf.retrotranslator.runtime.java.lang._System;
import net.sf.retrotranslator.runtime.java.lang._Thread;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.UTF8Buffer;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.mqtt.client.CallbackConnection;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.codec.CONNECT;

public class MQTT {
    private static final long KEEP_ALIVE = Long.parseLong(_System.getProperty("mqtt.thread.keep_alive", "1000"));
    private static final long STACK_SIZE = Long.parseLong(_System.getProperty("mqtt.thread.stack_size", "524288"));
    private static ThreadPoolExecutor blockingThreadPool;
    private static final URI DEFAULT_HOST;
    URI host = DEFAULT_HOST;
    URI localAddress;
    SSLContext sslContext;
    DispatchQueue dispatchQueue;
    Executor blockingExecutor;
    int maxReadRate;
    int maxWriteRate;
    int trafficClass = 8;
    int receiveBufferSize = 65536;
    int sendBufferSize = 65536;
    boolean useLocalHost = true;
    CONNECT connect = new CONNECT();
    long reconnectDelay = 10L;
    long reconnectDelayMax = 30000L;
    double reconnectBackOffMultiplier = 2.0;
    long reconnectAttemptsMax = -1L;
    long connectAttemptsMax = -1L;

    public static synchronized ThreadPoolExecutor getBlockingThreadPool() {
        if (blockingThreadPool == null) {
            blockingThreadPool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, KEEP_ALIVE, TimeUnit.MILLISECONDS, new SynchronousQueue(), new ThreadFactory(){

                public Thread newThread(Runnable r) {
                    _Thread.AdvancedThreadBuilder advancedThreadBuilder = _Thread.createInstanceBuilder(null, r, "MQTT Task", STACK_SIZE);
                    Thread rc = new Thread(advancedThreadBuilder.argument1(), advancedThreadBuilder.argument2(), advancedThreadBuilder.argument3(), advancedThreadBuilder.argument4());
                    rc.setDaemon(true);
                    return rc;
                }
            }){

                public void shutdown() {
                }
            };
        }
        return blockingThreadPool;
    }

    public MQTT() {
    }

    public MQTT(MQTT other) {
        this.host = other.host;
        this.localAddress = other.localAddress;
        this.sslContext = other.sslContext;
        this.dispatchQueue = other.dispatchQueue;
        this.blockingExecutor = other.blockingExecutor;
        this.maxReadRate = other.maxReadRate;
        this.maxWriteRate = other.maxWriteRate;
        this.trafficClass = other.trafficClass;
        this.receiveBufferSize = other.receiveBufferSize;
        this.sendBufferSize = other.sendBufferSize;
        this.useLocalHost = other.useLocalHost;
        this.connect = new CONNECT(other.connect);
        this.reconnectDelay = other.reconnectDelay;
        this.reconnectDelayMax = other.reconnectDelayMax;
        this.reconnectBackOffMultiplier = other.reconnectBackOffMultiplier;
        this.reconnectAttemptsMax = other.reconnectAttemptsMax;
        this.connectAttemptsMax = other.connectAttemptsMax;
    }

    public CallbackConnection callbackConnection() {
        if (!this.isCleanSession() && this.getClientId() == null) {
            throw new IllegalArgumentException("The client id MUST be configured when clean session is set to false");
        }
        return new CallbackConnection(new MQTT(this));
    }

    public UTF8Buffer getClientId() {
        return this.connect.clientId();
    }

    public short getKeepAlive() {
        return this.connect.keepAlive();
    }

    public boolean isCleanSession() {
        return this.connect.cleanSession();
    }

    public void setCleanSession(boolean cleanSession) {
        this.connect.cleanSession(cleanSession);
    }

    public void setClientId(String clientId) {
        this.setClientId(Buffer.utf8(clientId));
    }

    public void setClientId(UTF8Buffer clientId) {
        this.connect.clientId(clientId);
    }

    public void setKeepAlive(short keepAlive) {
        this.connect.keepAlive(keepAlive);
    }

    public void setPassword(String password) {
        this.setPassword(Buffer.utf8(password));
    }

    public void setPassword(UTF8Buffer password) {
        this.connect.password(password);
    }

    public void setUserName(String userName) {
        this.setUserName(Buffer.utf8(userName));
    }

    public void setUserName(UTF8Buffer userName) {
        this.connect.userName(userName);
    }

    public void setWillMessage(String willMessage) {
        this.connect.willMessage(Buffer.utf8(willMessage));
    }

    public void setWillQos(QoS willQos) {
        this.connect.willQos(willQos);
    }

    public void setWillRetain(boolean willRetain) {
        this.connect.willRetain(willRetain);
    }

    public void setWillTopic(String willTopic) {
        this.setWillTopic(Buffer.utf8(willTopic));
    }

    public void setWillTopic(UTF8Buffer willTopic) {
        this.connect.willTopic(willTopic);
    }

    public void setHost(String host) throws URISyntaxException {
        this.setHost(new URI(host));
    }

    public void setHost(URI host) {
        this.host = host;
    }

    static {
        try {
            DEFAULT_HOST = new URI("tcp://127.0.0.1:1883");
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
    }
}

