/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.runtime.asm;

import net.sf.retrotranslator.runtime.asm.AnnotationVisitor;
import net.sf.retrotranslator.runtime.asm.Attribute;
import net.sf.retrotranslator.runtime.asm.ClassVisitor;
import net.sf.retrotranslator.runtime.asm.ClassWriter;
import net.sf.retrotranslator.runtime.asm.Label;
import net.sf.retrotranslator.runtime.asm.MethodVisitor;
import net.sf.retrotranslator.runtime.asm.MethodWriter;
import net.sf.retrotranslator.runtime.asm.Type;

public class ClassReader {
    public final byte[] b;
    private int[] items;
    private String[] strings;
    private int maxStringLength;
    public final int header;

    public ClassReader(byte[] b) {
        this(b, 0, b.length);
    }

    public ClassReader(byte[] b, int off, int len) {
        this.b = b;
        this.items = new int[this.readUnsignedShort(off + 8)];
        int ll = this.items.length;
        this.strings = new String[ll];
        int max = 0;
        int index = off + 10;
        for (int i = 1; i < ll; ++i) {
            int size;
            this.items[i] = index + 1;
            byte tag = b[index];
            switch (tag) {
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    size = 5;
                    break;
                }
                case 5: 
                case 6: {
                    size = 9;
                    ++i;
                    break;
                }
                case 1: {
                    size = 3 + this.readUnsignedShort(index + 1);
                    if (size <= max) break;
                    max = size;
                    break;
                }
                default: {
                    size = 3;
                }
            }
            index += size;
        }
        this.maxStringLength = max;
        this.header = index;
    }

    public void accept(ClassVisitor classVisitor, boolean skipDebug) {
        this.accept(classVisitor, new Attribute[0], skipDebug);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void accept(ClassVisitor var1_1, Attribute[] var2_2, boolean var3_3) {
        var4_4 = this.b;
        var5_5 = new char[this.maxStringLength];
        var18_6 = 0;
        var19_7 = 0;
        var20_8 = null;
        var9_9 = this.header;
        var13_10 = this.readUnsignedShort(var9_9);
        var14_11 = this.readClass(var9_9 + 2, var5_5);
        var10_12 = this.items[this.readUnsignedShort(var9_9 + 4)];
        var21_13 = var10_12 == 0 ? null : this.readUTF8(var10_12, var5_5);
        var22_14 = new String[this.readUnsignedShort(var9_9 + 6)];
        var11_15 = 0;
        var9_9 += 8;
        for (var6_16 = 0; var6_16 < var22_14.length; ++var6_16) {
            var22_14[var6_16] = this.readClass(var9_9, var5_5);
            var9_9 += 2;
        }
        var10_12 = var9_9;
        var6_16 = this.readUnsignedShort(var10_12);
        var10_12 += 2;
        while (var6_16 > 0) {
            var7_17 = this.readUnsignedShort(var10_12 + 6);
            var10_12 += 8;
            while (var7_17 > 0) {
                var10_12 += 6 + this.readInt(var10_12 + 2);
                --var7_17;
            }
            --var6_16;
        }
        var6_16 = this.readUnsignedShort(var10_12);
        var10_12 += 2;
        while (var6_16 > 0) {
            var7_17 = this.readUnsignedShort(var10_12 + 6);
            var10_12 += 8;
            while (var7_17 > 0) {
                var10_12 += 6 + this.readInt(var10_12 + 2);
                --var7_17;
            }
            --var6_16;
        }
        var17_18 = null;
        var23_19 = null;
        var24_20 = null;
        var25_21 = null;
        var26_22 = null;
        var27_23 = null;
        var6_16 = this.readUnsignedShort(var10_12);
        var10_12 += 2;
        while (var6_16 > 0) {
            var16_25 = this.readUTF8(var10_12, var5_5);
            if (var16_25.equals("SourceFile")) {
                var23_19 = this.readUTF8(var10_12 + 6, var5_5);
            } else if (var16_25.equals("Deprecated")) {
                var13_10 |= 131072;
            } else if (var16_25.equals("Synthetic")) {
                var13_10 |= 4096;
            } else if (var16_25.equals("Annotation")) {
                var13_10 |= 8192;
            } else if (var16_25.equals("Enum")) {
                var13_10 |= 16384;
            } else if (var16_25.equals("InnerClasses")) {
                var11_15 = var10_12 + 6;
            } else if (var16_25.equals("Signature")) {
                var17_18 = this.readUTF8(var10_12 + 6, var5_5);
            } else if (var16_25.equals("SourceDebugExtension")) {
                var28_26 = this.readInt(var10_12 + 2);
                var24_20 = this.readUTF(var10_12 + 6, var28_26, new char[var28_26]);
            } else if (var16_25.equals("EnclosingMethod")) {
                var25_21 = this.readClass(var10_12 + 6, var5_5);
                var28_26 = this.readUnsignedShort(var10_12 + 8);
                if (var28_26 != 0) {
                    var26_22 = this.readUTF8(this.items[var28_26], var5_5);
                    var27_23 = this.readUTF8(this.items[var28_26] + 2, var5_5);
                }
            } else if (var16_25.equals("RuntimeVisibleAnnotations")) {
                var18_6 = var10_12 + 6;
            } else if (var16_25.equals("RuntimeInvisibleAnnotations")) {
                var19_7 = var10_12 + 6;
            } else {
                var12_24 = this.readAttribute(var2_2, var16_25, var10_12 + 6, this.readInt(var10_12 + 2), var5_5, -1, null);
                if (var12_24 != null) {
                    var12_24.next = var20_8;
                    var20_8 = var12_24;
                }
            }
            var10_12 += 6 + this.readInt(var10_12 + 2);
            --var6_16;
        }
        var1_1.visit(this.readInt(4), var13_10, var14_11, var17_18, var21_13, var22_14);
        if (var23_19 != null || var24_20 != null) {
            var1_1.visitSource(var23_19, var24_20);
        }
        if (var25_21 != null) {
            var1_1.visitOuterClass(var25_21, var26_22, var27_23);
        }
        for (var6_16 = 1; var6_16 >= 0; --var6_16) {
            v0 = var10_12 = var6_16 == 0 ? var19_7 : var18_6;
            if (var10_12 == 0) continue;
            var7_17 = this.readUnsignedShort(var10_12);
            var10_12 += 2;
            while (var7_17 > 0) {
                var15_27 = this.readUTF8(var10_12, var5_5);
                var10_12 += 2;
                var10_12 = this.readAnnotationValues(var10_12, var5_5, var1_1.visitAnnotation(var15_27, var6_16 != 0));
                --var7_17;
            }
        }
        while (var20_8 != null) {
            var12_24 = var20_8.next;
            var20_8.next = null;
            var1_1.visitAttribute(var20_8);
            var20_8 = var12_24;
        }
        if (var11_15 != 0) {
            var6_16 = this.readUnsignedShort(var11_15);
            var11_15 += 2;
            while (var6_16 > 0) {
                var1_1.visitInnerClass(this.readUnsignedShort(var11_15) == 0 ? null : this.readClass(var11_15, var5_5), this.readUnsignedShort(var11_15 + 2) == 0 ? null : this.readClass(var11_15 + 2, var5_5), this.readUnsignedShort(var11_15 + 4) == 0 ? null : this.readUTF8(var11_15 + 4, var5_5), this.readUnsignedShort(var11_15 + 6));
                var11_15 += 8;
                --var6_16;
            }
        }
        var6_16 = this.readUnsignedShort(var9_9);
        var9_9 += 2;
        while (var6_16 > 0) {
            var13_10 = this.readUnsignedShort(var9_9);
            var14_11 = this.readUTF8(var9_9 + 2, var5_5);
            var15_27 = this.readUTF8(var9_9 + 4, var5_5);
            var28_26 = 0;
            var17_18 = null;
            var18_6 = 0;
            var19_7 = 0;
            var20_8 = null;
            var7_17 = this.readUnsignedShort(var9_9 + 6);
            var9_9 += 8;
            while (var7_17 > 0) {
                var16_25 = this.readUTF8(var9_9, var5_5);
                if (var16_25.equals("ConstantValue")) {
                    var28_26 = this.readUnsignedShort(var9_9 + 6);
                } else if (var16_25.equals("Synthetic")) {
                    var13_10 |= 4096;
                } else if (var16_25.equals("Deprecated")) {
                    var13_10 |= 131072;
                } else if (var16_25.equals("Enum")) {
                    var13_10 |= 16384;
                } else if (var16_25.equals("Signature")) {
                    var17_18 = this.readUTF8(var9_9 + 6, var5_5);
                } else if (var16_25.equals("RuntimeVisibleAnnotations")) {
                    var18_6 = var9_9 + 6;
                } else if (var16_25.equals("RuntimeInvisibleAnnotations")) {
                    var19_7 = var9_9 + 6;
                } else {
                    var12_24 = this.readAttribute(var2_2, var16_25, var9_9 + 6, this.readInt(var9_9 + 2), var5_5, -1, null);
                    if (var12_24 != null) {
                        var12_24.next = var20_8;
                        var20_8 = var12_24;
                    }
                }
                var9_9 += 6 + this.readInt(var9_9 + 2);
                --var7_17;
            }
            var29_29 = var28_26 == 0 ? null : this.readConst(var28_26, var5_5);
            var30_31 = var1_1.visitField(var13_10, var14_11, var15_27, var17_18, var29_29);
            if (var30_31 != null) {
                for (var7_17 = 1; var7_17 >= 0; --var7_17) {
                    v1 = var10_12 = var7_17 == 0 ? var19_7 : var18_6;
                    if (var10_12 == 0) continue;
                    var8_28 = this.readUnsignedShort(var10_12);
                    var10_12 += 2;
                    while (var8_28 > 0) {
                        var15_27 = this.readUTF8(var10_12, var5_5);
                        var10_12 += 2;
                        var10_12 = this.readAnnotationValues(var10_12, var5_5, var30_31.visitAnnotation(var15_27, var7_17 != 0));
                        --var8_28;
                    }
                }
                while (var20_8 != null) {
                    var12_24 = var20_8.next;
                    var20_8.next = null;
                    var30_31.visitAttribute(var20_8);
                    var20_8 = var12_24;
                }
                var30_31.visitEnd();
            }
            --var6_16;
        }
        var6_16 = this.readUnsignedShort(var9_9);
        var9_9 += 2;
        while (var6_16 > 0) {
            var28_26 = var9_9 + 6;
            var13_10 = this.readUnsignedShort(var9_9);
            var14_11 = this.readUTF8(var9_9 + 2, var5_5);
            var15_27 = this.readUTF8(var9_9 + 4, var5_5);
            var17_18 = null;
            var18_6 = 0;
            var19_7 = 0;
            var29_30 = 0;
            var30_32 = 0;
            var31_33 = 0;
            var20_8 = null;
            var10_12 = 0;
            var11_15 = 0;
            var7_17 = this.readUnsignedShort(var9_9 + 6);
            var9_9 += 8;
            while (var7_17 > 0) {
                var16_25 = this.readUTF8(var9_9, var5_5);
                var32_35 = this.readInt(var9_9 += 2);
                var9_9 += 4;
                if (var16_25.equals("Code")) {
                    var10_12 = var9_9;
                } else if (var16_25.equals("Exceptions")) {
                    var11_15 = var9_9;
                } else if (var16_25.equals("Synthetic")) {
                    var13_10 |= 4096;
                } else if (var16_25.equals("Varargs")) {
                    var13_10 |= 128;
                } else if (var16_25.equals("Bridge")) {
                    var13_10 |= 64;
                } else if (var16_25.equals("Deprecated")) {
                    var13_10 |= 131072;
                } else if (var16_25.equals("Signature")) {
                    var17_18 = this.readUTF8(var9_9, var5_5);
                } else if (var16_25.equals("AnnotationDefault")) {
                    var29_30 = var9_9;
                } else if (var16_25.equals("RuntimeVisibleAnnotations")) {
                    var18_6 = var9_9;
                } else if (var16_25.equals("RuntimeInvisibleAnnotations")) {
                    var19_7 = var9_9;
                } else if (var16_25.equals("RuntimeVisibleParameterAnnotations")) {
                    var30_32 = var9_9;
                } else if (var16_25.equals("RuntimeInvisibleParameterAnnotations")) {
                    var31_33 = var9_9;
                } else {
                    var12_24 = this.readAttribute(var2_2, var16_25, var9_9, var32_35, var5_5, -1, null);
                    if (var12_24 != null) {
                        var12_24.next = var20_8;
                        var20_8 = var12_24;
                    }
                }
                var9_9 += var32_35;
                --var7_17;
            }
            if (var11_15 == 0) {
                var32_34 = null;
            } else {
                var32_34 = new String[this.readUnsignedShort(var11_15)];
                var11_15 += 2;
                for (var7_17 = 0; var7_17 < var32_34.length; ++var7_17) {
                    var32_34[var7_17] = this.readClass(var11_15, var5_5);
                    var11_15 += 2;
                }
            }
            var33_36 = var1_1.visitMethod(var13_10, var14_11, var15_27, var17_18, var32_34);
            if (var33_36 == null) ** GOTO lbl314
            if (!(var33_36 instanceof MethodWriter)) ** GOTO lbl-1000
            var34_37 = (MethodWriter)var33_36;
            if (var34_37.cw.cr != this || var17_18 != var34_37.signature) ** GOTO lbl-1000
            var35_39 = 0;
            if (var32_34 == null) {
                var35_39 = var34_37.exceptionCount == 0 ? 1 : 0;
            } else if (var32_34.length == var34_37.exceptionCount) {
                var35_39 = 1;
                for (var7_17 = var32_34.length - 1; var7_17 >= 0; --var7_17) {
                    if (var34_37.exceptions[var7_17] == this.readUnsignedShort(var11_15 -= 2)) continue;
                    var35_39 = 0;
                    break;
                }
            }
            if (var35_39 != 0) {
                var34_37.classReaderOffset = var28_26;
                var34_37.classReaderLength = var9_9 - var28_26;
            } else lbl-1000:
            // 3 sources

            {
                if (var29_30 != 0) {
                    var34_37 = var33_36.visitAnnotationDefault();
                    this.readAnnotationValue(var29_30, var5_5, null, (AnnotationVisitor)var34_37);
                    var34_37.visitEnd();
                }
                for (var7_17 = 1; var7_17 >= 0; --var7_17) {
                    v2 = var11_15 = var7_17 == 0 ? var19_7 : var18_6;
                    if (var11_15 == 0) continue;
                    var8_28 = this.readUnsignedShort(var11_15);
                    var11_15 += 2;
                    while (var8_28 > 0) {
                        var15_27 = this.readUTF8(var11_15, var5_5);
                        var11_15 += 2;
                        var11_15 = this.readAnnotationValues(var11_15, var5_5, var33_36.visitAnnotation(var15_27, var7_17 != 0));
                        --var8_28;
                    }
                }
                if (var30_32 != 0) {
                    this.readParameterAnnotations(var30_32, var5_5, true, var33_36);
                }
                if (var31_33 != 0) {
                    this.readParameterAnnotations(var31_33, var5_5, false, var33_36);
                }
                while (var20_8 != null) {
                    var12_24 = var20_8.next;
                    var20_8.next = null;
                    var33_36.visitAttribute(var20_8);
                    var20_8 = var12_24;
                }
lbl314:
                // 2 sources

                if (var33_36 != null && var10_12 != 0) {
                    var34_38 = this.readUnsignedShort(var10_12);
                    var35_39 = this.readUnsignedShort(var10_12 + 2);
                    var36_40 = this.readInt(var10_12 + 4);
                    var37_41 = var10_12 += 8;
                    var38_42 = var10_12 + var36_40;
                    var33_36.visitCode();
                    var40_44 = new Label[var36_40 + 1];
                    block50: while (var10_12 < var38_42) {
                        var41_45 = var4_4[var10_12] & 255;
                        switch (ClassWriter.TYPE[var41_45]) {
                            case 0: 
                            case 4: {
                                ++var10_12;
                                continue block50;
                            }
                            case 8: {
                                var39_43 = var10_12 - var37_41 + this.readShort(var10_12 + 1);
                                if (var40_44[var39_43] == null) {
                                    var40_44[var39_43] = new Label();
                                }
                                var10_12 += 3;
                                continue block50;
                            }
                            case 9: {
                                var39_43 = var10_12 - var37_41 + this.readInt(var10_12 + 1);
                                if (var40_44[var39_43] == null) {
                                    var40_44[var39_43] = new Label();
                                }
                                var10_12 += 5;
                                continue block50;
                            }
                            case 16: {
                                var41_45 = var4_4[var10_12 + 1] & 255;
                                if (var41_45 == 132) {
                                    var10_12 += 6;
                                    continue block50;
                                }
                                var10_12 += 4;
                                continue block50;
                            }
                            case 13: {
                                var11_15 = var10_12 - var37_41;
                                var10_12 = var10_12 + 4 - (var11_15 & 3);
                                var39_43 = var11_15 + this.readInt(var10_12);
                                var10_12 += 4;
                                if (var40_44[var39_43] == null) {
                                    var40_44[var39_43] = new Label();
                                }
                                var7_17 = this.readInt(var10_12);
                                var10_12 += 4;
                                for (var7_17 = this.readInt(var10_12 += 4) - var7_17 + 1; var7_17 > 0; --var7_17) {
                                    var39_43 = var11_15 + this.readInt(var10_12);
                                    var10_12 += 4;
                                    if (var40_44[var39_43] != null) continue;
                                    var40_44[var39_43] = new Label();
                                }
                                continue block50;
                            }
                            case 14: {
                                var11_15 = var10_12 - var37_41;
                                var10_12 = var10_12 + 4 - (var11_15 & 3);
                                var39_43 = var11_15 + this.readInt(var10_12);
                                var10_12 += 4;
                                if (var40_44[var39_43] == null) {
                                    var40_44[var39_43] = new Label();
                                }
                                var7_17 = this.readInt(var10_12);
                                var10_12 += 4;
                                while (var7_17 > 0) {
                                    var39_43 = var11_15 + this.readInt(var10_12 += 4);
                                    var10_12 += 4;
                                    if (var40_44[var39_43] == null) {
                                        var40_44[var39_43] = new Label();
                                    }
                                    --var7_17;
                                }
                                continue block50;
                            }
                            case 1: 
                            case 3: 
                            case 10: {
                                var10_12 += 2;
                                continue block50;
                            }
                            case 2: 
                            case 5: 
                            case 6: 
                            case 11: 
                            case 12: {
                                var10_12 += 3;
                                continue block50;
                            }
                            case 7: {
                                var10_12 += 5;
                                continue block50;
                            }
                        }
                        var10_12 += 4;
                    }
                    var7_17 = this.readUnsignedShort(var10_12);
                    var10_12 += 2;
                    while (var7_17 > 0) {
                        var39_43 = this.readUnsignedShort(var10_12);
                        var41_47 = var40_44[var39_43];
                        if (var41_47 == null) {
                            var40_44[var39_43] = var41_47 = new Label();
                        }
                        if ((var42_49 = var40_44[var39_43 = this.readUnsignedShort(var10_12 + 2)]) == null) {
                            var40_44[var39_43] = var42_49 = new Label();
                        }
                        if ((var43_50 = var40_44[var39_43 = this.readUnsignedShort(var10_12 + 4)]) == null) {
                            var40_44[var39_43] = var43_50 = new Label();
                        }
                        if ((var44_51 = this.readUnsignedShort(var10_12 + 6)) == 0) {
                            var33_36.visitTryCatchBlock(var41_47, var42_49, var43_50, null);
                        } else {
                            var33_36.visitTryCatchBlock(var41_47, var42_49, var43_50, this.readUTF8(this.items[var44_51], var5_5));
                        }
                        var10_12 += 8;
                        --var7_17;
                    }
                    var41_45 = 0;
                    var42_48 = 0;
                    var20_8 = null;
                    var7_17 = this.readUnsignedShort(var10_12);
                    var10_12 += 2;
                    while (var7_17 > 0) {
                        var16_25 = this.readUTF8(var10_12, var5_5);
                        if (var16_25.equals("LocalVariableTable")) {
                            if (!var3_3) {
                                var41_45 = var10_12 + 6;
                                var11_15 = var10_12 + 8;
                                for (var8_28 = this.readUnsignedShort(var10_12 + 6); var8_28 > 0; --var8_28) {
                                    var39_43 = this.readUnsignedShort(var11_15);
                                    if (var40_44[var39_43] == null) {
                                        var40_44[var39_43] = new Label();
                                    }
                                    if (var40_44[var39_43 += this.readUnsignedShort(var11_15 + 2)] == null) {
                                        var40_44[var39_43] = new Label();
                                    }
                                    var11_15 += 10;
                                }
                            }
                        } else if (var16_25.equals("LocalVariableTypeTable")) {
                            var42_48 = var10_12 + 6;
                        } else if (var16_25.equals("LineNumberTable")) {
                            if (!var3_3) {
                                var11_15 = var10_12 + 8;
                                for (var8_28 = this.readUnsignedShort(var10_12 + 6); var8_28 > 0; --var8_28) {
                                    var39_43 = this.readUnsignedShort(var11_15);
                                    if (var40_44[var39_43] == null) {
                                        var40_44[var39_43] = new Label();
                                    }
                                    var40_44[var39_43].line = this.readUnsignedShort(var11_15 + 2);
                                    var11_15 += 4;
                                }
                            }
                        } else {
                            for (var8_28 = 0; var8_28 < var2_2.length; ++var8_28) {
                                if (!var2_2[var8_28].type.equals(var16_25) || (var12_24 = var2_2[var8_28].read(this, var10_12 + 6, this.readInt(var10_12 + 2), var5_5, var37_41 - 8, var40_44)) == null) continue;
                                var12_24.next = var20_8;
                                var20_8 = var12_24;
                            }
                        }
                        var10_12 += 6 + this.readInt(var10_12 + 2);
                        --var7_17;
                    }
                    var10_12 = var37_41;
                    block58: while (var10_12 < var38_42) {
                        var11_15 = var10_12 - var37_41;
                        var43_50 = var40_44[var11_15];
                        if (var43_50 != null) {
                            var33_36.visitLabel(var43_50);
                            if (!var3_3 && var43_50.line > 0) {
                                var33_36.visitLineNumber(var43_50.line, var43_50);
                            }
                        }
                        var44_51 = var4_4[var10_12] & 255;
                        switch (ClassWriter.TYPE[var44_51]) {
                            case 0: {
                                var33_36.visitInsn(var44_51);
                                ++var10_12;
                                continue block58;
                            }
                            case 4: {
                                if (var44_51 > 54) {
                                    var33_36.visitVarInsn(54 + ((var44_51 -= 59) >> 2), var44_51 & 3);
                                } else {
                                    var33_36.visitVarInsn(21 + ((var44_51 -= 26) >> 2), var44_51 & 3);
                                }
                                ++var10_12;
                                continue block58;
                            }
                            case 8: {
                                var33_36.visitJumpInsn(var44_51, var40_44[var11_15 + this.readShort(var10_12 + 1)]);
                                var10_12 += 3;
                                continue block58;
                            }
                            case 9: {
                                var33_36.visitJumpInsn(var44_51 - 33, var40_44[var11_15 + this.readInt(var10_12 + 1)]);
                                var10_12 += 5;
                                continue block58;
                            }
                            case 16: {
                                var44_51 = var4_4[var10_12 + 1] & 255;
                                if (var44_51 == 132) {
                                    var33_36.visitIincInsn(this.readUnsignedShort(var10_12 + 2), this.readShort(var10_12 + 4));
                                    var10_12 += 6;
                                    continue block58;
                                }
                                var33_36.visitVarInsn(var44_51, this.readUnsignedShort(var10_12 + 2));
                                var10_12 += 4;
                                continue block58;
                            }
                            case 13: {
                                var10_12 = var10_12 + 4 - (var11_15 & 3);
                                var39_43 = var11_15 + this.readInt(var10_12);
                                var45_53 = this.readInt(var10_12 += 4);
                                var46_54 = this.readInt(var10_12 += 4);
                                var10_12 += 4;
                                var47_55 = new Label[var46_54 - var45_53 + 1];
                                for (var7_17 = 0; var7_17 < var47_55.length; ++var7_17) {
                                    var47_55[var7_17] = var40_44[var11_15 + this.readInt(var10_12)];
                                    var10_12 += 4;
                                }
                                var33_36.visitTableSwitchInsn(var45_53, var46_54, var40_44[var39_43], var47_55);
                                continue block58;
                            }
                            case 14: {
                                var10_12 = var10_12 + 4 - (var11_15 & 3);
                                var39_43 = var11_15 + this.readInt(var10_12);
                                var7_17 = this.readInt(var10_12 += 4);
                                var10_12 += 4;
                                var48_57 /* !! */  = new int[var7_17];
                                var49_58 = new Label[var7_17];
                                for (var7_17 = 0; var7_17 < var48_57 /* !! */ .length; ++var7_17) {
                                    var48_57 /* !! */ [var7_17] = this.readInt(var10_12);
                                    var49_58[var7_17] = var40_44[var11_15 + this.readInt(var10_12 += 4)];
                                    var10_12 += 4;
                                }
                                var33_36.visitLookupSwitchInsn(var40_44[var39_43], var48_57 /* !! */ , var49_58);
                                continue block58;
                            }
                            case 3: {
                                var33_36.visitVarInsn(var44_51, var4_4[var10_12 + 1] & 255);
                                var10_12 += 2;
                                continue block58;
                            }
                            case 1: {
                                var33_36.visitIntInsn(var44_51, var4_4[var10_12 + 1]);
                                var10_12 += 2;
                                continue block58;
                            }
                            case 2: {
                                var33_36.visitIntInsn(var44_51, this.readShort(var10_12 + 1));
                                var10_12 += 3;
                                continue block58;
                            }
                            case 10: {
                                var33_36.visitLdcInsn(this.readConst(var4_4[var10_12 + 1] & 255, var5_5));
                                var10_12 += 2;
                                continue block58;
                            }
                            case 11: {
                                var33_36.visitLdcInsn(this.readConst(this.readUnsignedShort(var10_12 + 1), var5_5));
                                var10_12 += 3;
                                continue block58;
                            }
                            case 6: 
                            case 7: {
                                var50_60 = this.items[this.readUnsignedShort(var10_12 + 1)];
                                var51_61 = this.readClass(var50_60, var5_5);
                                var50_60 = this.items[this.readUnsignedShort(var50_60 + 2)];
                                var52_62 = this.readUTF8(var50_60, var5_5);
                                var53_63 = this.readUTF8(var50_60 + 2, var5_5);
                                if (var44_51 < 182) {
                                    var33_36.visitFieldInsn(var44_51, var51_61, var52_62, var53_63);
                                } else {
                                    var33_36.visitMethodInsn(var44_51, var51_61, var52_62, var53_63);
                                }
                                if (var44_51 == 185) {
                                    var10_12 += 5;
                                    continue block58;
                                }
                                var10_12 += 3;
                                continue block58;
                            }
                            case 5: {
                                var33_36.visitTypeInsn(var44_51, this.readClass(var10_12 + 1, var5_5));
                                var10_12 += 3;
                                continue block58;
                            }
                            case 12: {
                                var33_36.visitIincInsn(var4_4[var10_12 + 1] & 255, var4_4[var10_12 + 2]);
                                var10_12 += 3;
                                continue block58;
                            }
                        }
                        var33_36.visitMultiANewArrayInsn(this.readClass(var10_12 + 1, var5_5), var4_4[var10_12 + 3] & 255);
                        var10_12 += 4;
                    }
                    var43_50 = var40_44[var38_42 - var37_41];
                    if (var43_50 != null) {
                        var33_36.visitLabel(var43_50);
                    }
                    if (!var3_3 && var41_45 != 0) {
                        var44_52 = null;
                        if (var42_48 != 0) {
                            var11_15 = var42_48;
                            var8_28 = this.readUnsignedShort(var11_15) * 3;
                            var11_15 += 2;
                            var44_52 = new int[var8_28];
                            while (var8_28 > 0) {
                                var44_52[--var8_28] = var11_15 + 6;
                                var44_52[--var8_28] = this.readUnsignedShort(var11_15 + 8);
                                var44_52[--var8_28] = this.readUnsignedShort(var11_15);
                                var11_15 += 10;
                            }
                        }
                        var11_15 = var41_45;
                        var8_28 = this.readUnsignedShort(var11_15);
                        var11_15 += 2;
                        while (var8_28 > 0) {
                            var45_53 = this.readUnsignedShort(var11_15);
                            var46_54 = this.readUnsignedShort(var11_15 + 2);
                            var47_56 = this.readUnsignedShort(var11_15 + 8);
                            var48_57 /* !! */  = null;
                            if (var44_52 != null) {
                                for (var49_59 = 0; var49_59 < var44_52.length; var49_59 += 3) {
                                    if (var44_52[var49_59] != var45_53 || var44_52[var49_59 + 1] != var47_56) continue;
                                    var48_57 /* !! */  = (int[])this.readUTF8(var44_52[var49_59 + 2], var5_5);
                                    break;
                                }
                            }
                            var33_36.visitLocalVariable(this.readUTF8(var11_15 + 4, var5_5), this.readUTF8(var11_15 + 6, var5_5), (String)var48_57 /* !! */ , var40_44[var45_53], var40_44[var45_53 + var46_54], var47_56);
                            var11_15 += 10;
                            --var8_28;
                        }
                    }
                    while (var20_8 != null) {
                        var12_24 = var20_8.next;
                        var20_8.next = null;
                        var33_36.visitAttribute(var20_8);
                        var20_8 = var12_24;
                    }
                    var33_36.visitMaxs(var34_38, var35_39);
                }
                if (var33_36 != null) {
                    var33_36.visitEnd();
                }
            }
            --var6_16;
        }
        var1_1.visitEnd();
    }

    private void readParameterAnnotations(int v, char[] buf, boolean visible, MethodVisitor mv) {
        int n = this.b[v++] & 0xFF;
        for (int i = 0; i < n; ++i) {
            int j = this.readUnsignedShort(v);
            v += 2;
            while (j > 0) {
                String desc = this.readUTF8(v, buf);
                v += 2;
                AnnotationVisitor av = mv.visitParameterAnnotation(i, desc, visible);
                v = this.readAnnotationValues(v, buf, av);
                --j;
            }
        }
    }

    private int readAnnotationValues(int v, char[] buf, AnnotationVisitor av) {
        int i = this.readUnsignedShort(v);
        v += 2;
        while (i > 0) {
            String name = this.readUTF8(v, buf);
            v += 2;
            v = this.readAnnotationValue(v, buf, name, av);
            --i;
        }
        av.visitEnd();
        return v;
    }

    private int readAnnotationValue(int v, char[] buf, String name, AnnotationVisitor av) {
        block0 : switch (this.readByte(v++)) {
            case 68: 
            case 70: 
            case 73: 
            case 74: {
                av.visit(name, this.readConst(this.readUnsignedShort(v), buf));
                v += 2;
                break;
            }
            case 66: {
                av.visit(name, new Byte((byte)this.readInt(this.items[this.readUnsignedShort(v)])));
                v += 2;
                break;
            }
            case 90: {
                boolean b = this.readInt(this.items[this.readUnsignedShort(v)]) == 0;
                av.visit(name, b ? Boolean.FALSE : Boolean.TRUE);
                v += 2;
                break;
            }
            case 83: {
                av.visit(name, new Short((short)this.readInt(this.items[this.readUnsignedShort(v)])));
                v += 2;
                break;
            }
            case 67: {
                av.visit(name, new Character((char)this.readInt(this.items[this.readUnsignedShort(v)])));
                v += 2;
                break;
            }
            case 115: {
                av.visit(name, this.readUTF8(v, buf));
                v += 2;
                break;
            }
            case 101: {
                av.visitEnum(name, this.readUTF8(v, buf), this.readUTF8(v + 2, buf));
                v += 4;
                break;
            }
            case 99: {
                av.visit(name, Type.getType(this.readUTF8(v, buf)));
                v += 2;
                break;
            }
            case 64: {
                String desc = this.readUTF8(v, buf);
                v += 2;
                v = this.readAnnotationValues(v, buf, av.visitAnnotation(name, desc));
                break;
            }
            case 91: {
                int size = this.readUnsignedShort(v);
                v += 2;
                if (size == 0) {
                    av.visitArray(name).visitEnd();
                    return v;
                }
                switch (this.readByte(v++)) {
                    case 66: {
                        byte[] bv = new byte[size];
                        for (int i = 0; i < size; ++i) {
                            bv[i] = (byte)this.readInt(this.items[this.readUnsignedShort(v)]);
                            v += 3;
                        }
                        av.visit(name, bv);
                        --v;
                        break block0;
                    }
                    case 90: {
                        boolean[] zv = new boolean[size];
                        for (int i = 0; i < size; ++i) {
                            zv[i] = this.readInt(this.items[this.readUnsignedShort(v)]) != 0;
                            v += 3;
                        }
                        av.visit(name, zv);
                        --v;
                        break block0;
                    }
                    case 83: {
                        short[] sv = new short[size];
                        for (int i = 0; i < size; ++i) {
                            sv[i] = (short)this.readInt(this.items[this.readUnsignedShort(v)]);
                            v += 3;
                        }
                        av.visit(name, sv);
                        --v;
                        break block0;
                    }
                    case 67: {
                        char[] cv = new char[size];
                        for (int i = 0; i < size; ++i) {
                            cv[i] = (char)this.readInt(this.items[this.readUnsignedShort(v)]);
                            v += 3;
                        }
                        av.visit(name, cv);
                        --v;
                        break block0;
                    }
                    case 73: {
                        int[] iv = new int[size];
                        for (int i = 0; i < size; ++i) {
                            iv[i] = this.readInt(this.items[this.readUnsignedShort(v)]);
                            v += 3;
                        }
                        av.visit(name, iv);
                        --v;
                        break block0;
                    }
                    case 74: {
                        long[] lv = new long[size];
                        for (int i = 0; i < size; ++i) {
                            lv[i] = this.readLong(this.items[this.readUnsignedShort(v)]);
                            v += 3;
                        }
                        av.visit(name, lv);
                        --v;
                        break block0;
                    }
                    case 70: {
                        float[] fv = new float[size];
                        for (int i = 0; i < size; ++i) {
                            fv[i] = Float.intBitsToFloat(this.readInt(this.items[this.readUnsignedShort(v)]));
                            v += 3;
                        }
                        av.visit(name, fv);
                        --v;
                        break block0;
                    }
                    case 68: {
                        double[] dv = new double[size];
                        for (int i = 0; i < size; ++i) {
                            dv[i] = Double.longBitsToDouble(this.readLong(this.items[this.readUnsignedShort(v)]));
                            v += 3;
                        }
                        av.visit(name, dv);
                        --v;
                        break block0;
                    }
                }
                --v;
                AnnotationVisitor aav = av.visitArray(name);
                for (int i = size; i > 0; --i) {
                    v = this.readAnnotationValue(v, buf, null, aav);
                }
                aav.visitEnd();
            }
        }
        return v;
    }

    private Attribute readAttribute(Attribute[] attrs, String type, int off, int len, char[] buf, int codeOff, Label[] labels) {
        for (int i = 0; i < attrs.length; ++i) {
            if (!attrs[i].type.equals(type)) continue;
            return attrs[i].read(this, off, len, buf, codeOff, labels);
        }
        return new Attribute(type).read(this, off, len, null, -1, null);
    }

    public int readByte(int index) {
        return this.b[index] & 0xFF;
    }

    public int readUnsignedShort(int index) {
        byte[] b = this.b;
        return (b[index] & 0xFF) << 8 | b[index + 1] & 0xFF;
    }

    public short readShort(int index) {
        byte[] b = this.b;
        return (short)((b[index] & 0xFF) << 8 | b[index + 1] & 0xFF);
    }

    public int readInt(int index) {
        byte[] b = this.b;
        return (b[index] & 0xFF) << 24 | (b[index + 1] & 0xFF) << 16 | (b[index + 2] & 0xFF) << 8 | b[index + 3] & 0xFF;
    }

    public long readLong(int index) {
        long l1 = this.readInt(index);
        long l0 = (long)this.readInt(index + 4) & 0xFFFFFFFFL;
        return l1 << 32 | l0;
    }

    public String readUTF8(int index, char[] buf) {
        int item = this.readUnsignedShort(index);
        String s = this.strings[item];
        if (s != null) {
            return s;
        }
        index = this.items[item];
        this.strings[item] = this.readUTF(index + 2, this.readUnsignedShort(index), buf);
        return this.strings[item];
    }

    private String readUTF(int index, int utfLen, char[] buf) {
        int endIndex = index + utfLen;
        byte[] b = this.b;
        int strLen = 0;
        block4: while (index < endIndex) {
            byte d;
            int c = b[index++] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    buf[strLen++] = (char)c;
                    continue block4;
                }
                case 12: 
                case 13: {
                    d = b[index++];
                    buf[strLen++] = (char)((c & 0x1F) << 6 | d & 0x3F);
                    continue block4;
                }
            }
            d = b[index++];
            byte e = b[index++];
            buf[strLen++] = (char)((c & 0xF) << 12 | (d & 0x3F) << 6 | e & 0x3F);
        }
        return new String(buf, 0, strLen);
    }

    public String readClass(int index, char[] buf) {
        return this.readUTF8(this.items[this.readUnsignedShort(index)], buf);
    }

    public Object readConst(int n, char[] cArray) {
        int n2 = this.items[n];
        switch (this.b[n2 - 1]) {
            case 3: {
                return new Integer(this.readInt(n2));
            }
            case 4: {
                return new Float(Float.intBitsToFloat(this.readInt(n2)));
            }
            case 5: {
                return new Long(this.readLong(n2));
            }
            case 6: {
                return new Double(Double.longBitsToDouble(this.readLong(n2)));
            }
            case 7: {
                String string = this.readUTF8(n2, cArray);
                return Type.getType(string.charAt(0) == '[' ? string : "L" + string + ";");
            }
        }
        return this.readUTF8(n2, cArray);
    }
}

