/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mqtt.client;

import java.util.ArrayList;
import java.util.LinkedList;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.UTF8Buffer;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.Task;
import org.fusesource.mqtt.client.Callback;
import org.fusesource.mqtt.client.CallbackConnection;
import org.fusesource.mqtt.client.ExtendedListener;
import org.fusesource.mqtt.client.Future;
import org.fusesource.mqtt.client.Message;
import org.fusesource.mqtt.client.Promise;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.client.Topic;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FutureConnection {
    private final CallbackConnection next;
    private final LinkedList<Promise<Message>> receiveFutures = new LinkedList();
    private final LinkedList<Message> receivedFrames = new LinkedList();
    private volatile boolean connected;
    private long receiveBuffer;
    private long receiveBufferRemaining = this.receiveBuffer = 0x100000L;
    private boolean receiveBufferFull = false;

    public FutureConnection(CallbackConnection next) {
        this.next = next;
        this.next.listener(new ExtendedListener(){

            @Override
            public void onConnected() {
                FutureConnection.this.connected = true;
            }

            @Override
            public void onDisconnected() {
                FutureConnection.this.connected = false;
            }

            @Override
            public void onPublish(UTF8Buffer topic, final Buffer payload, final Callback<Callback<Void>> onComplete) {
                FutureConnection.this.getDispatchQueue().assertExecuting();
                FutureConnection.this.receiveBufferRemaining -= payload.length();
                if (!FutureConnection.this.receiveBufferFull && FutureConnection.this.receiveBufferRemaining <= 0L) {
                    FutureConnection.this.receiveBufferFull = true;
                    FutureConnection.this.suspend();
                }
                FutureConnection.this.deliverMessage(new Message(FutureConnection.this.getDispatchQueue(), topic, payload, new Callback<Callback<Void>>(){

                    @Override
                    public void onSuccess(Callback<Void> value) {
                        this.processed();
                        onComplete.onSuccess(value);
                    }

                    @Override
                    public void onFailure(Throwable value) {
                        this.processed();
                        onComplete.onFailure(value);
                    }

                    private void processed() {
                        FutureConnection.this.getDispatchQueue().assertExecuting();
                        FutureConnection.this.receiveBufferRemaining += payload.length();
                        if (FutureConnection.this.receiveBufferFull && FutureConnection.this.receiveBufferRemaining > 0L) {
                            FutureConnection.this.receiveBufferFull = false;
                            FutureConnection.this.resume();
                        }
                    }

                    @Override
                    public /* synthetic */ void onSuccess(Object x0) {
                        this.onSuccess((Callback)x0);
                    }
                }));
            }

            @Override
            public void onPublish(UTF8Buffer topic, Buffer payload, final Runnable onComplete) {
                this.onPublish(topic, payload, new Callback<Callback<Void>>(){

                    @Override
                    public void onSuccess(Callback<Void> value) {
                        onComplete.run();
                    }

                    @Override
                    public void onFailure(Throwable value) {
                    }

                    @Override
                    public /* synthetic */ void onSuccess(Object x0) {
                        this.onSuccess((Callback)x0);
                    }
                });
            }

            @Override
            public void onFailure(Throwable value) {
                FutureConnection.this.getDispatchQueue().assertExecuting();
                ArrayList tmp = new ArrayList(FutureConnection.this.receiveFutures);
                FutureConnection.this.receiveFutures.clear();
                for (Promise future : tmp) {
                    future.onFailure(value);
                }
                FutureConnection.this.connected = false;
            }
        });
    }

    void deliverMessage(Message msg) {
        if (this.receiveFutures.isEmpty()) {
            this.receivedFrames.add(msg);
        } else {
            this.receiveFutures.removeFirst().onSuccess(msg);
        }
    }

    void putBackMessage(Message msg) {
        if (this.receiveFutures.isEmpty()) {
            this.receivedFrames.addFirst(msg);
        } else {
            this.receiveFutures.removeFirst().onSuccess(msg);
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public DispatchQueue getDispatchQueue() {
        return this.next.getDispatchQueue();
    }

    public Future<Void> connect() {
        final Promise<Void> future = new Promise<Void>();
        this.next.getDispatchQueue().execute(new Task(){

            public void run() {
                FutureConnection.this.next.connect(future);
            }
        });
        return future;
    }

    public Future<Void> disconnect() {
        final Promise<Void> future = new Promise<Void>();
        this.next.getDispatchQueue().execute(new Task(){

            public void run() {
                FutureConnection.this.next.disconnect(future);
            }
        });
        return future;
    }

    public Future<Void> kill() {
        final Promise<Void> future = new Promise<Void>();
        this.next.getDispatchQueue().execute(new Task(){

            public void run() {
                FutureConnection.this.next.kill(future);
            }
        });
        return future;
    }

    public Future<byte[]> subscribe(final Topic[] topics) {
        final Promise<byte[]> future = new Promise<byte[]>();
        this.next.getDispatchQueue().execute(new Task(){

            public void run() {
                FutureConnection.this.next.subscribe(topics, future);
            }
        });
        return future;
    }

    public Future<Void> unsubscribe(String[] topics) {
        UTF8Buffer[] buffers = new UTF8Buffer[topics.length];
        for (int i = 0; i < buffers.length; ++i) {
            buffers[i] = new UTF8Buffer(topics[i]);
        }
        return this.unsubscribe(buffers);
    }

    public Future<Void> unsubscribe(final UTF8Buffer[] topics) {
        final Promise<Void> future = new Promise<Void>();
        this.next.getDispatchQueue().execute(new Task(){

            public void run() {
                FutureConnection.this.next.unsubscribe(topics, future);
            }
        });
        return future;
    }

    public Future<Void> publish(String topic, byte[] payload, QoS qos, boolean retain) {
        return this.publish(Buffer.utf8(topic), new Buffer(payload), qos, retain);
    }

    public Future<Void> publish(final UTF8Buffer topic, final Buffer payload, final QoS qos, final boolean retain) {
        final Promise<Void> future = new Promise<Void>();
        this.next.getDispatchQueue().execute(new Task(){

            public void run() {
                FutureConnection.this.next.publish(topic, payload, qos, retain, (Callback<Void>)future);
            }
        });
        return future;
    }

    public Future<Message> receive() {
        final Promise<Message> future = new Promise<Message>();
        this.getDispatchQueue().execute(new Task(){

            public void run() {
                if (FutureConnection.this.next.failure() != null) {
                    future.onFailure(FutureConnection.this.next.failure());
                } else if (FutureConnection.this.receivedFrames.isEmpty()) {
                    FutureConnection.this.receiveFutures.add(future);
                } else {
                    future.onSuccess(FutureConnection.this.receivedFrames.removeFirst());
                }
            }
        });
        return future;
    }

    public long getReceiveBuffer() {
        this.getDispatchQueue().assertExecuting();
        return this.receiveBuffer;
    }

    public void setReceiveBuffer(long receiveBuffer) {
        this.getDispatchQueue().assertExecuting();
        long prev = this.receiveBuffer;
        this.receiveBuffer = receiveBuffer;
        long diff = prev - receiveBuffer;
        this.receiveBufferRemaining -= diff;
        if (!this.receiveBufferFull && this.receiveBufferRemaining <= 0L) {
            this.receiveBufferFull = true;
            this.suspend();
        } else if (this.receiveBufferFull && this.receiveBufferRemaining > 0L) {
            this.receiveBufferFull = false;
            this.resume();
        }
    }

    public void resume() {
        this.next.resume();
    }

    public void suspend() {
        this.next.suspend();
    }
}

