/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mqtt.codec;

import java.io.IOException;
import java.net.ProtocolException;
import net.sf.retrotranslator.runtime.java.lang._Class;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.DataByteArrayInputStream;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;
import org.fusesource.hawtbuf.UTF8Buffer;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.codec.MQTTFrame;

public final class MessageSupport {
    private MessageSupport() throws InstantiationException {
        throw new InstantiationException("This class is not for instantiation");
    }

    protected static UTF8Buffer readUTF(DataByteArrayInputStream is) throws ProtocolException {
        int size = is.readUnsignedShort();
        Buffer buffer = is.readBuffer(size);
        if (buffer == null || buffer.length != size) {
            throw new ProtocolException("Invalid message encoding");
        }
        return buffer.utf8();
    }

    protected static void writeUTF(DataByteArrayOutputStream os, Buffer buffer) throws IOException {
        os.writeShort(buffer.length);
        os.write(buffer);
    }

    public static class HeaderBase {
        protected byte header;

        protected byte header() {
            return this.header;
        }

        protected HeaderBase header(byte header) {
            this.header = header;
            return this;
        }

        protected byte messageType() {
            return (byte)((this.header & 0xF0) >>> 4);
        }

        protected HeaderBase commandType(int type) {
            this.header = (byte)(this.header & 0xF);
            this.header = (byte)(this.header | type << 4 & 0xF0);
            return this;
        }

        protected QoS qos() {
            return QoS.values()[(this.header & 6) >>> 1];
        }

        protected HeaderBase qos(QoS qos) {
            this.header = (byte)(this.header & 0xF9);
            this.header = (byte)(this.header | qos.ordinal() << 1 & 6);
            return this;
        }

        protected boolean dup() {
            return (this.header & 8) > 0;
        }

        protected HeaderBase dup(boolean dup) {
            this.header = dup ? (byte)(this.header | 8) : (byte)(this.header & 0xF7);
            return this;
        }

        protected boolean retain() {
            return (this.header & 1) > 0;
        }

        protected HeaderBase retain(boolean retain) {
            this.header = retain ? (byte)(this.header | 1) : (byte)(this.header & 0xFE);
            return this;
        }
    }

    public static abstract class EmptyBase {
        abstract byte messageType();

        protected EmptyBase decode(MQTTFrame frame) throws ProtocolException {
            return this;
        }

        public MQTTFrame encode() {
            return new MQTTFrame().commandType(this.messageType());
        }
    }

    public static abstract class AckBase {
        short messageId;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$org$fusesource$mqtt$codec$MessageSupport;

        abstract byte messageType();

        protected AckBase decode(MQTTFrame frame) throws ProtocolException {
            if (!$assertionsDisabled && frame.buffers.length != 1) {
                throw new AssertionError();
            }
            DataByteArrayInputStream is = new DataByteArrayInputStream(frame.buffers[0]);
            this.messageId = is.readShort();
            return this;
        }

        public MQTTFrame encode() {
            try {
                DataByteArrayOutputStream os = new DataByteArrayOutputStream(2);
                os.writeShort(this.messageId);
                MQTTFrame frame = new MQTTFrame();
                frame.commandType(this.messageType());
                return frame.buffer(os.toBuffer());
            }
            catch (IOException e) {
                throw new RuntimeException("The impossible happened");
            }
        }

        public short messageId() {
            return this.messageId;
        }

        protected AckBase messageId(short messageId) {
            this.messageId = messageId;
            return this;
        }

        public String toString() {
            return _Class.getSimpleName(this.getClass()) + "{" + "messageId=" + this.messageId + '}';
        }

        static {
            Class<?> clazz = class$org$fusesource$mqtt$codec$MessageSupport;
            if (clazz == null) {
                clazz = class$org$fusesource$mqtt$codec$MessageSupport = new MessageSupport[0].getClass().getComponentType();
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }
    }

    public static interface Acked
    extends Message {
        public boolean dup();

        public Acked dup(boolean var1);

        public QoS qos();

        public short messageId();

        public Acked messageId(short var1);
    }

    public static interface Message {
        public byte messageType();

        public Message decode(MQTTFrame var1) throws ProtocolException;

        public MQTTFrame encode();
    }
}

