/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mqtt.codec;

import java.io.IOException;
import java.net.ProtocolException;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.DataByteArrayInputStream;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;
import org.fusesource.hawtbuf.UTF8Buffer;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.codec.MQTTFrame;
import org.fusesource.mqtt.codec.MessageSupport;

public class PUBLISH
extends MessageSupport.HeaderBase
implements MessageSupport.Acked,
MessageSupport.Message {
    private UTF8Buffer topicName;
    private short messageId;
    private Buffer payload;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$fusesource$mqtt$codec$PUBLISH;

    public PUBLISH() {
        this.qos(QoS.AT_LEAST_ONCE);
    }

    public byte messageType() {
        return 3;
    }

    public PUBLISH decode(MQTTFrame frame) throws ProtocolException {
        if (!$assertionsDisabled && frame.buffers.length != 1) {
            throw new AssertionError();
        }
        this.header(frame.header());
        DataByteArrayInputStream is = new DataByteArrayInputStream(frame.buffers[0]);
        this.topicName = MessageSupport.readUTF(is);
        QoS qos = this.qos();
        if (qos != QoS.AT_MOST_ONCE) {
            this.messageId = is.readShort();
        }
        this.payload = is.readBuffer(is.available());
        if (this.payload == null) {
            this.payload = new Buffer(0);
        }
        return this;
    }

    public MQTTFrame encode() {
        try {
            DataByteArrayOutputStream variableHeader = new DataByteArrayOutputStream();
            MessageSupport.writeUTF(variableHeader, this.topicName);
            QoS qos = this.qos();
            if (qos != QoS.AT_MOST_ONCE) {
                variableHeader.writeShort(this.messageId);
            }
            MQTTFrame frame = new MQTTFrame();
            frame.header(this.header());
            frame.commandType(3);
            if (this.payload == null || this.payload.length == 0) {
                frame.buffer(variableHeader.toBuffer());
            } else {
                frame.buffers(new Buffer[]{variableHeader.toBuffer(), this.payload});
            }
            return frame;
        }
        catch (IOException e) {
            throw new RuntimeException("The impossible happened");
        }
    }

    public boolean dup() {
        return super.dup();
    }

    public PUBLISH dup(boolean dup) {
        return (PUBLISH)super.dup(dup);
    }

    public QoS qos() {
        return super.qos();
    }

    public PUBLISH qos(QoS qos) {
        return (PUBLISH)super.qos(qos);
    }

    public boolean retain() {
        return super.retain();
    }

    public PUBLISH retain(boolean retain) {
        return (PUBLISH)super.retain(retain);
    }

    public short messageId() {
        return this.messageId;
    }

    public PUBLISH messageId(short messageId) {
        this.messageId = messageId;
        return this;
    }

    public Buffer payload() {
        return this.payload;
    }

    public PUBLISH payload(Buffer payload) {
        this.payload = payload;
        return this;
    }

    public UTF8Buffer topicName() {
        return this.topicName;
    }

    public PUBLISH topicName(UTF8Buffer topicName) {
        this.topicName = topicName;
        return this;
    }

    public String toString() {
        return "PUBLISH{dup=" + this.dup() + ", qos=" + this.qos() + ", retain=" + this.retain() + ", messageId=" + this.messageId + ", topicName=" + this.topicName + ", payload=" + this.payload + '}';
    }

    public /* synthetic */ MessageSupport.HeaderBase retain(boolean x0) {
        return this.retain(x0);
    }

    public /* synthetic */ MessageSupport.HeaderBase dup(boolean x0) {
        return this.dup(x0);
    }

    public /* synthetic */ MessageSupport.HeaderBase qos(QoS x0) {
        return this.qos(x0);
    }

    public /* synthetic */ MessageSupport.Acked messageId(short x0) {
        return this.messageId(x0);
    }

    static {
        Class<?> clazz = class$org$fusesource$mqtt$codec$PUBLISH;
        if (clazz == null) {
            clazz = class$org$fusesource$mqtt$codec$PUBLISH = new PUBLISH[0].getClass().getComponentType();
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }
}

