/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.transport;

import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLSession;
import net.sf.retrotranslator.runtime.java.lang._Integer;
import org.fusesource.hawtdispatch.transport.SecureTransport;
import org.fusesource.hawtdispatch.transport.TcpTransport;

public class SslTransport
extends TcpTransport
implements SecureTransport {
    private SSLContext sslContext;
    private SSLEngine engine;
    private ByteBuffer readBuffer;
    private boolean readUnderflow;
    private ByteBuffer writeBuffer;
    private boolean writeFlushing;
    private ByteBuffer readOverflowBuffer;
    private SSLChannel ssl_channel = new SSLChannel();
    private Executor blockingExecutor;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$fusesource$hawtdispatch$transport$SslTransport;

    public static String protocol(String scheme) {
        if (scheme.equals("tls")) {
            return "TLS";
        }
        if (scheme.startsWith("tlsv")) {
            return "TLSv" + scheme.substring(4);
        }
        if (scheme.equals("ssl")) {
            return "SSL";
        }
        if (scheme.startsWith("sslv")) {
            return "SSLv" + scheme.substring(4);
        }
        return null;
    }

    public void setSSLContext(SSLContext ctx) {
        this.sslContext = ctx;
    }

    public void connecting(URI remoteLocation, URI localLocation) throws Exception {
        if (!$assertionsDisabled && this.engine != null) {
            throw new AssertionError();
        }
        this.engine = this.sslContext.createSSLEngine();
        this.engine.setUseClientMode(true);
        super.connecting(remoteLocation, localLocation);
    }

    protected void initializeChannel() throws Exception {
        super.initializeChannel();
        SSLSession session = this.engine.getSession();
        this.readBuffer = ByteBuffer.allocateDirect(session.getPacketBufferSize());
        this.readBuffer.flip();
        this.writeBuffer = ByteBuffer.allocateDirect(session.getPacketBufferSize());
    }

    protected void onConnected() throws IOException {
        super.onConnected();
        this.engine.beginHandshake();
        this.handshake();
    }

    public void flush() {
        if (this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            this.handshake();
        } else {
            super.flush();
        }
    }

    protected void drainInbound() {
        if (this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            this.handshake();
        } else {
            super.drainInbound();
        }
    }

    protected boolean transportFlush() throws IOException {
        while (true) {
            if (this.writeFlushing) {
                int count = super.writeChannel().write(this.writeBuffer);
                if (!this.writeBuffer.hasRemaining()) {
                    this.writeBuffer.clear();
                    this.writeFlushing = false;
                    this.suspendWrite();
                    return true;
                }
                return false;
            }
            if (this.writeBuffer.position() == 0) break;
            this.writeBuffer.flip();
            this.writeFlushing = true;
            this.resumeWrite();
        }
        return true;
    }

    private int secure_write(ByteBuffer plain) throws IOException {
        if (!this.transportFlush()) {
            return 0;
        }
        int rc = 0;
        while (plain.hasRemaining() ^ this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
            SSLEngineResult result = this.engine.wrap(plain, this.writeBuffer);
            if (!$assertionsDisabled && result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                throw new AssertionError();
            }
            rc += result.bytesConsumed();
            if (this.transportFlush()) continue;
            break;
        }
        if (plain.remaining() == 0 && this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            this.dispatchQueue.execute(new Runnable(){

                public void run() {
                    SslTransport.this.handshake();
                }
            });
        }
        return rc;
    }

    private int secure_read(ByteBuffer byteBuffer) throws IOException {
        int n = 0;
        while (byteBuffer.hasRemaining() ^ this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
            if (this.readOverflowBuffer != null) {
                if (byteBuffer.hasRemaining()) {
                    int n2 = Math.min(byteBuffer.remaining(), this.readOverflowBuffer.remaining());
                    byteBuffer.put(this.readOverflowBuffer.array(), this.readOverflowBuffer.position(), n2);
                    this.readOverflowBuffer.position(this.readOverflowBuffer.position() + n2);
                    if (!this.readOverflowBuffer.hasRemaining()) {
                        this.readOverflowBuffer = null;
                    }
                    n += n2;
                    continue;
                }
                return n;
            }
            if (this.readUnderflow) {
                int n3 = super.readChannel().read(this.readBuffer);
                if (n3 == -1) {
                    if (n == 0) {
                        return -1;
                    }
                    return n;
                }
                if (n3 == 0) {
                    return n;
                }
                this.readUnderflow = false;
                this.readBuffer.flip();
                continue;
            }
            SSLEngineResult sSLEngineResult = this.engine.unwrap(this.readBuffer, byteBuffer);
            n += sSLEngineResult.bytesProduced();
            if (sSLEngineResult.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                this.readOverflowBuffer = ByteBuffer.allocate(this.engine.getSession().getApplicationBufferSize());
                sSLEngineResult = this.engine.unwrap(this.readBuffer, this.readOverflowBuffer);
                if (this.readOverflowBuffer.position() == 0) {
                    this.readOverflowBuffer = null;
                } else {
                    this.readOverflowBuffer.flip();
                }
            }
            switch (4.$SwitchMap$javax$net$ssl$SSLEngineResult$Status[sSLEngineResult.getStatus().ordinal()]) {
                case 1: {
                    if (n == 0) {
                        this.engine.closeInbound();
                        return -1;
                    }
                    return n;
                }
                case 2: {
                    if (this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) break;
                    this.dispatchQueue.execute(new Runnable(){

                        public void run() {
                            SslTransport.this.handshake();
                        }
                    });
                    break;
                }
                case 3: {
                    this.readBuffer.compact();
                    this.readUnderflow = true;
                    break;
                }
                case 4: {
                    throw new AssertionError((Object)"Unexpected case.");
                }
            }
        }
        return n;
    }

    public void handshake() {
        try {
            if (!this.transportFlush()) {
                return;
            }
            switch (4.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[this.engine.getHandshakeStatus().ordinal()]) {
                case 1: {
                    final Runnable runnable = this.engine.getDelegatedTask();
                    if (runnable != null) {
                        this.blockingExecutor.execute(new Runnable(){

                            public void run() {
                                runnable.run();
                                SslTransport.this.dispatchQueue.execute(new Runnable(){

                                    public void run() {
                                        if (SslTransport.this.isConnected()) {
                                            SslTransport.this.handshake();
                                        }
                                    }
                                });
                            }
                        });
                    }
                    break;
                }
                case 2: {
                    this.secure_write(ByteBuffer.allocate(0));
                    break;
                }
                case 3: {
                    if (this.secure_read(ByteBuffer.allocate(0)) == -1) {
                        throw new EOFException("Peer disconnected during ssl handshake");
                    }
                    break;
                }
                case 4: 
                case 5: {
                    this.drainOutboundSource.merge(_Integer.valueOf(1));
                    break;
                }
                default: {
                    System.err.println("Unexpected ssl engine handshake status: " + (Object)((Object)this.engine.getHandshakeStatus()));
                    break;
                }
            }
        }
        catch (IOException iOException) {
            this.onTransportFailure(iOException);
        }
    }

    public ReadableByteChannel readChannel() {
        return this.ssl_channel;
    }

    public WritableByteChannel writeChannel() {
        return this.ssl_channel;
    }

    public void setBlockingExecutor(Executor blockingExecutor) {
        this.blockingExecutor = blockingExecutor;
    }

    static {
        Class<?> clazz = class$org$fusesource$hawtdispatch$transport$SslTransport;
        if (clazz == null) {
            clazz = class$org$fusesource$hawtdispatch$transport$SslTransport = new SslTransport[0].getClass().getComponentType();
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    static class 4 {
        static final /* synthetic */ int[] $SwitchMap$javax$net$ssl$SSLEngineResult$Status;
        static final /* synthetic */ int[] $SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus;

        static {
            $SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus = new int[SSLEngineResult.HandshakeStatus.values().length];
            try {
                4.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[SSLEngineResult.HandshakeStatus.NEED_TASK.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                4.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[SSLEngineResult.HandshakeStatus.NEED_WRAP.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                4.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[SSLEngineResult.HandshakeStatus.NEED_UNWRAP.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                4.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[SSLEngineResult.HandshakeStatus.FINISHED.ordinal()] = 4;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                4.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING.ordinal()] = 5;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            $SwitchMap$javax$net$ssl$SSLEngineResult$Status = new int[SSLEngineResult.Status.values().length];
            try {
                4.$SwitchMap$javax$net$ssl$SSLEngineResult$Status[SSLEngineResult.Status.CLOSED.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                4.$SwitchMap$javax$net$ssl$SSLEngineResult$Status[SSLEngineResult.Status.OK.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                4.$SwitchMap$javax$net$ssl$SSLEngineResult$Status[SSLEngineResult.Status.BUFFER_UNDERFLOW.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                4.$SwitchMap$javax$net$ssl$SSLEngineResult$Status[SSLEngineResult.Status.BUFFER_OVERFLOW.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    public class SSLChannel
    implements GatheringByteChannel,
    ScatteringByteChannel {
        public int write(ByteBuffer plain) throws IOException {
            return SslTransport.this.secure_write(plain);
        }

        public int read(ByteBuffer plain) throws IOException {
            return SslTransport.this.secure_read(plain);
        }

        public boolean isOpen() {
            return SslTransport.this.getSocketChannel().isOpen();
        }

        public void close() throws IOException {
            SslTransport.this.getSocketChannel().close();
        }

        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            if (offset + length > srcs.length || length < 0 || offset < 0) {
                throw new IndexOutOfBoundsException();
            }
            long rc = 0L;
            for (int i = 0; i < length; ++i) {
                ByteBuffer src = srcs[offset + i];
                if (src.hasRemaining()) {
                    rc += (long)this.write(src);
                }
                if (!src.hasRemaining()) continue;
                return rc;
            }
            return rc;
        }

        public long write(ByteBuffer[] srcs) throws IOException {
            return this.write(srcs, 0, srcs.length);
        }

        public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
            if (offset + length > dsts.length || length < 0 || offset < 0) {
                throw new IndexOutOfBoundsException();
            }
            long rc = 0L;
            for (int i = 0; i < length; ++i) {
                ByteBuffer dst = dsts[offset + i];
                if (dst.hasRemaining()) {
                    rc += (long)this.read(dst);
                }
                if (!dst.hasRemaining()) continue;
                return rc;
            }
            return rc;
        }

        public long read(ByteBuffer[] dsts) throws IOException {
            return this.read(dsts, 0, dsts.length);
        }

        public Socket socket() {
            SocketChannel c = SslTransport.this.channel;
            if (c == null) {
                return null;
            }
            return c.socket();
        }
    }
}

