/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.insight.log.service;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.karaf.shell.log.LruList;
import org.apache.karaf.shell.log.VmLogAppender;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.fusesource.insight.log.LogFilter;
import org.fusesource.insight.log.LogResults;
import org.fusesource.insight.log.service.LogQueryMBean;
import org.fusesource.insight.log.service.Logs;
import org.fusesource.insight.log.support.Predicate;
import org.ops4j.pax.logging.spi.PaxLoggingEvent;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogQuery
implements LogQueryMBean {
    private transient Logger logger = LoggerFactory.getLogger(LogQuery.class);
    private BundleContext bundleContext;
    private VmLogAppender appender;
    private ObjectName mbeanName;
    private ObjectMapper mapper = new ObjectMapper();
    private ServiceTracker serviceTracker;

    public LogQuery() {
        this.mapper.getSerializationConfig().withSerializationInclusion(JsonSerialize.Inclusion.NON_EMPTY);
    }

    public void init() throws Exception {
        if (this.bundleContext == null) {
            throw new IllegalArgumentException("No bundleContext injected!");
        }
        ServiceTrackerCustomizer customizer = null;
        this.serviceTracker = new ServiceTracker(this.bundleContext, "org.ops4j.pax.logging.spi.PaxAppender", customizer);
        this.serviceTracker.open();
    }

    public void destroy() throws Exception {
        if (this.serviceTracker != null) {
            this.serviceTracker.close();
            this.serviceTracker = null;
        }
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public ObjectName getMbeanName() throws MalformedObjectNameException {
        if (this.mbeanName == null) {
            this.mbeanName = new ObjectName("org.fusesource.insight:type=LogQuery");
        }
        return this.mbeanName;
    }

    public void setMbeanName(ObjectName mbeanName) {
        this.mbeanName = mbeanName;
    }

    public void registerMBeanServer(MBeanServer mbeanServer) {
        try {
            ObjectName name = this.getMbeanName();
            ObjectInstance objectInstance = mbeanServer.registerMBean(this, name);
        }
        catch (Exception e) {
            this.logger.warn("An error occured during mbean server registration: " + e, (Throwable)e);
        }
    }

    public void unregisterMBeanServer(MBeanServer mbeanServer) {
        if (mbeanServer != null) {
            try {
                mbeanServer.unregisterMBean(this.getMbeanName());
            }
            catch (Exception e) {
                this.logger.warn("An error occured during mbean server registration: " + e, (Throwable)e);
            }
        }
    }

    @Override
    public String filterLogEvents(String jsonFilter) throws IOException {
        LogFilter filter = this.jsonToLogFilter(jsonFilter);
        LogResults events = this.getLogEventList(filter);
        return this.toJSON(events);
    }

    @Override
    public String getLogEvents(int count) throws IOException {
        LogResults events = this.getLogEventList(count, null);
        return this.toJSON(events);
    }

    protected String toJSON(LogResults answer) throws IOException {
        try {
            StringWriter writer = new StringWriter();
            this.mapper.writeValue((Writer)writer, (Object)answer);
            return writer.toString();
        }
        catch (IOException e) {
            this.logger.warn("Failed to marshal the events: " + e, (Throwable)e);
            throw new IOException(e.getMessage());
        }
    }

    protected LogFilter jsonToLogFilter(String json) throws IOException {
        if (json == null) {
            return null;
        }
        if ((json = json.trim()).length() == 0 || json.equals("{}")) {
            return null;
        }
        return (LogFilter)this.mapper.reader(LogFilter.class).readValue(json);
    }

    public LogResults getLogEventList(LogFilter filter) {
        Predicate<PaxLoggingEvent> predicate = Logs.createPredicate(filter);
        int count = -1;
        if (filter != null) {
            count = filter.getCount();
        }
        return this.getLogEventList(count, predicate);
    }

    public LogResults getLogEventList(int count, Predicate<PaxLoggingEvent> predicate) {
        LogResults answer = new LogResults();
        try {
            answer.setHost(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            this.logger.warn("Failed to get host name: " + e, (Throwable)e);
        }
        VmLogAppender a = this.getAppender();
        if (a != null) {
            LruList events = a.getEvents();
            Iterable iterable = events.getElements();
            int matched = 0;
            long from = Long.MAX_VALUE;
            long to = Long.MIN_VALUE;
            for (PaxLoggingEvent event : iterable) {
                long timestamp = event.getTimeStamp();
                if (timestamp > to) {
                    to = timestamp;
                }
                if (timestamp < from) {
                    from = timestamp;
                }
                if (predicate != null && !predicate.matches(event)) continue;
                answer.addEvent(Logs.newInstance(event));
                if (count <= 0 || ++matched < count) continue;
                break;
            }
            answer.setFromTimestamp(from);
            answer.setToTimestamp(to);
        } else {
            this.logger.warn("No VmLogAppender available!");
        }
        return answer;
    }

    public VmLogAppender getAppender() {
        Object[] services;
        if (this.appender == null && this.serviceTracker != null && (services = this.serviceTracker.getServices()) != null) {
            for (Object service : services) {
                if (!(service instanceof VmLogAppender)) continue;
                return (VmLogAppender)service;
            }
        }
        return this.appender;
    }

    public void setAppender(VmLogAppender appender) {
        this.appender = appender;
    }
}

