/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.insight.graph.support;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerFactory {
    private static final transient Logger LOG = LoggerFactory.getLogger(SchedulerFactory.class);
    private static final String PID = "org.fusesource.insight.graph";
    private StdSchedulerFactory factory = new StdSchedulerFactory();
    private Properties properties = new Properties();
    private ConfigurationAdmin configAdmin;

    public Scheduler createScheduler() throws SchedulerException {
        if (this.configAdmin != null) {
            try {
                Configuration configuration = this.configAdmin.getConfiguration(PID);
                Dictionary dictionary = configuration.getProperties();
                if (dictionary == null) {
                    LOG.warn("No properties for configuration: org.fusesource.insight.graph");
                } else {
                    Enumeration e = dictionary.keys();
                    if (e == null) {
                        LOG.warn("No properties for configuration: org.fusesource.insight.graph");
                    } else {
                        this.properties = new Properties();
                        while (e.hasMoreElements()) {
                            Object key = e.nextElement();
                            if (key == null) continue;
                            this.properties.put(key.toString(), dictionary.get(key));
                        }
                    }
                }
            }
            catch (IOException e) {
                LOG.warn("Failed to get configuration for PID: org.fusesource.insight.graph");
            }
        }
        LOG.info("Creating Quartz Schedular using properties: " + this.properties);
        this.factory.initialize(this.properties);
        return this.factory.getScheduler();
    }

    public StdSchedulerFactory getFactory() {
        return this.factory;
    }

    public void setFactory(StdSchedulerFactory factory) {
        this.factory = factory;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public ConfigurationAdmin getConfigAdmin() {
        return this.configAdmin;
    }

    public void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }
}

