/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.jobs;

import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.util.JmxUtils;
import javax.management.remote.JMXConnector;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerJob
implements Job {
    private static final Logger log = LoggerFactory.getLogger(ServerJob.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap map = context.getMergedJobDataMap();
        Server server = (Server)map.get((Object)Server.class.getName());
        GenericKeyedObjectPool pool = (GenericKeyedObjectPool)map.get((Object)Server.JMX_CONNECTION_FACTORY_POOL);
        if (log.isDebugEnabled()) {
            log.debug("+++++ Started server job: " + server);
        }
        JMXConnector conn = null;
        try {
            if (server.getLocalMBeanServer() == null) {
                conn = (JMXConnector)pool.borrowObject((Object)server);
            }
            JmxUtils.processServer(server, conn);
        }
        catch (Exception e) {
            log.error("Error", (Throwable)e);
            throw new JobExecutionException((Throwable)e);
        }
        finally {
            try {
                if (conn != null) {
                    pool.returnObject((Object)server, (Object)conn);
                }
            }
            catch (Exception ex) {
                log.error("Error returning object to pool for server: " + server);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("+++++ Finished server job: " + server);
        }
    }
}

