/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtjni.maven;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;

@Mojo(name="package-source", defaultPhase=LifecyclePhase.PACKAGE)
public class PackageSourceMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Component
    private ArchiverManager archiverManager;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/hawtjni/native-package")
    private File packageDirectory;
    @Parameter(defaultValue="native-src")
    private String sourceClassifier;
    @Parameter(defaultValue="${skip-autogen}")
    private boolean skipAutogen;

    public void execute() throws MojoExecutionException {
        try {
            String packageName = this.project.getArtifactId() + "-" + this.project.getVersion() + "-" + this.sourceClassifier;
            File packageFile = new File(new File(this.project.getBuild().getDirectory()), packageName + ".zip");
            File configure = new File(this.packageDirectory, "configure");
            if (!this.skipAutogen && !configure.exists()) {
                this.getLog().info((CharSequence)"");
                this.getLog().warn((CharSequence)("Will NOT package the native sources to: " + packageFile));
                this.getLog().info((CharSequence)"  Native source build directory did not contain a 'configure' script.");
                this.getLog().info((CharSequence)"  To ignore this warning and package it up anyways, configure the plugin with: <skipAutogen>true</skipAutogen>");
                this.getLog().info((CharSequence)"");
                return;
            }
            Archiver archiver = this.archiverManager.getArchiver("zip");
            archiver.setDestFile(packageFile);
            archiver.setIncludeEmptyDirs(true);
            archiver.addDirectory(this.packageDirectory, packageName + "/");
            archiver.createArchive();
            this.projectHelper.attachArtifact(this.project, "zip", this.sourceClassifier, packageFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException("packageing failed: " + e, e);
        }
    }
}

