/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtjni.generator.model;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import org.fusesource.hawtjni.generator.model.JNIClass;
import org.fusesource.hawtjni.generator.model.JNIField;
import org.fusesource.hawtjni.generator.model.JNIType;
import org.fusesource.hawtjni.generator.model.ReflectClass;
import org.fusesource.hawtjni.generator.model.ReflectType;
import org.fusesource.hawtjni.generator.util.TextSupport;
import org.fusesource.hawtjni.runtime.FieldFlag;
import org.fusesource.hawtjni.runtime.JniField;
import org.fusesource.hawtjni.runtime.T32;

public class ReflectField
implements JNIField {
    private ReflectClass parent;
    private Field field;
    private ReflectType type;
    private JniField annotation;
    private HashSet<FieldFlag> flags;
    private boolean allowConversion;

    public ReflectField(ReflectClass parent, Field field) {
        this.parent = parent;
        this.field = field;
        this.lazyLoad();
    }

    public int hashCode() {
        return this.field.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ReflectField)) {
            return false;
        }
        return ((ReflectField)obj).field.equals(this.field);
    }

    public String toString() {
        return this.field.toString();
    }

    public JNIClass getDeclaringClass() {
        return this.parent;
    }

    public int getModifiers() {
        return this.field.getModifiers();
    }

    public String getName() {
        return this.field.getName();
    }

    public JNIType getType() {
        return this.type.asType32(this.allowConversion);
    }

    public JNIType getType64() {
        return this.type.asType64(this.allowConversion);
    }

    public String getAccessor() {
        return this.annotation == null ? "" : this.annotation.accessor();
    }

    public String getCast() {
        String rc = this.annotation == null ? "" : this.annotation.cast().trim();
        return TextSupport.cast(rc);
    }

    public boolean isPointer() {
        if (this.annotation == null) {
            return false;
        }
        return this.getFlag(FieldFlag.POINTER_FIELD) || this.type.getWrappedClass() == Long.TYPE && this.getCast().endsWith("*)");
    }

    public String getConditional() {
        String myConditional;
        String parentConditional = this.getDeclaringClass().getConditional();
        String string = myConditional = this.annotation == null ? null : ReflectField.emptyFilter(this.annotation.conditional());
        if (parentConditional != null) {
            if (myConditional != null) {
                return parentConditional + " && " + myConditional;
            }
            return parentConditional;
        }
        return myConditional;
    }

    public boolean getFlag(FieldFlag flag) {
        return this.flags.contains((Object)flag);
    }

    public static String emptyFilter(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        return value;
    }

    private void lazyLoad() {
        this.type = new ReflectType(this.field.getType());
        this.annotation = this.field.getAnnotation(JniField.class);
        this.flags = new HashSet();
        if (this.annotation != null) {
            this.flags.addAll(Arrays.asList(this.annotation.flags()));
        }
        this.allowConversion = this.field.getAnnotation(T32.class) != null;
    }
}

