/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.util.Arrays;
import org.fusesource.hawtjni.runtime.ArgFlag;
import org.fusesource.hawtjni.runtime.ClassFlag;
import org.fusesource.hawtjni.runtime.FieldFlag;
import org.fusesource.hawtjni.runtime.JniArg;
import org.fusesource.hawtjni.runtime.JniClass;
import org.fusesource.hawtjni.runtime.JniField;
import org.fusesource.hawtjni.runtime.JniMethod;
import org.fusesource.hawtjni.runtime.Library;
import org.fusesource.hawtjni.runtime.MethodFlag;

@JniClass
public class Example {
    private static final Library LIBRARY = new Library("hawtjni-example", Example.class);
    @JniField(flags={FieldFlag.CONSTANT})
    public static int O_RDONLY;
    @JniField(flags={FieldFlag.CONSTANT})
    public static int O_WRONLY;
    @JniField(flags={FieldFlag.CONSTANT})
    public static int O_RDWR;

    public static final void main(String[] args) {
        System.out.println("Checking Operating System Constants:");
        System.out.println(" O_RDONLY: " + O_RDONLY);
        System.out.println(" O_WRONLY: " + O_WRONLY);
        System.out.println("   O_RDWR: " + O_RDWR);
        System.out.println("");
        System.out.println("Allocating c structures on the heap...");
        int COUNT = 10;
        long[] ptrArray = new long[COUNT];
        long last = 0L;
        for (int i = 0; i < COUNT; ++i) {
            ptrArray[i] = Example.malloc(bar.SIZEOF);
            bar f = new bar();
            f.a = i;
            f.b = 1L;
            byte[] src = "hello world".getBytes();
            System.arraycopy(src, 0, f.c, 0, src.length);
            f.c5 = 0;
            f.prev = last;
            Example.memmove(ptrArray[i], f, (long)bar.SIZEOF);
            last = ptrArray[i];
        }
        System.out.println("Dump of the first 2 structures:");
        Example.print_foo(ptrArray[0]);
        Example.print_foo(ptrArray[1]);
        System.out.println("Passing a pointer array to a c function...");
        long rc = Example.foowork(ptrArray, COUNT);
        System.out.println("Function result (expecting 55): " + rc);
        System.out.println("freein up allocated memory.");
        for (int i = 0; i < COUNT; ++i) {
            Example.free(ptrArray[i]);
        }
    }

    @JniMethod(flags={MethodFlag.CONSTANT_INITIALIZER})
    private static final native void init();

    @JniMethod(cast="void *")
    public static final native long malloc(@JniArg(cast="size_t") long var0);

    public static final native void free(@JniArg(cast="void *") long var0);

    public static final native void memmove(@JniArg(cast="void *") long var0, @JniArg(cast="const void *") long var2, @JniArg(cast="size_t") long var4);

    public static final native void memmove(@JniArg(cast="void *") long var0, @JniArg(cast="const void *", flags={ArgFlag.NO_OUT, ArgFlag.CRITICAL}) byte[] var2, @JniArg(cast="size_t") long var3);

    public static final native void memmove(@JniArg(cast="void *") long var0, @JniArg(cast="const void *", flags={ArgFlag.NO_OUT, ArgFlag.CRITICAL}) char[] var2, @JniArg(cast="size_t") long var3);

    public static final native void memmove(@JniArg(cast="void *") long var0, @JniArg(cast="const void *", flags={ArgFlag.NO_OUT, ArgFlag.CRITICAL}) short[] var2, @JniArg(cast="size_t") long var3);

    public static final native void memmove(@JniArg(cast="void *") long var0, @JniArg(cast="const void *", flags={ArgFlag.NO_OUT, ArgFlag.CRITICAL}) int[] var2, @JniArg(cast="size_t") long var3);

    public static final native void memmove(@JniArg(cast="void *") long var0, @JniArg(cast="const void *", flags={ArgFlag.NO_OUT, ArgFlag.CRITICAL}) long[] var2, @JniArg(cast="size_t") long var3);

    public static final native void memmove(@JniArg(cast="void *") long var0, @JniArg(cast="const void *", flags={ArgFlag.NO_OUT, ArgFlag.CRITICAL}) float[] var2, @JniArg(cast="size_t") long var3);

    public static final native void memmove(@JniArg(cast="void *") long var0, @JniArg(cast="const void *", flags={ArgFlag.NO_OUT, ArgFlag.CRITICAL}) double[] var2, @JniArg(cast="size_t") long var3);

    public static final native void memmove(@JniArg(cast="void *", flags={ArgFlag.NO_IN, ArgFlag.CRITICAL}) byte[] var0, @JniArg(cast="const void *") long var1, @JniArg(cast="size_t") long var3);

    public static final native void memmove(@JniArg(cast="void *", flags={ArgFlag.NO_IN, ArgFlag.CRITICAL}) char[] var0, @JniArg(cast="const void *") long var1, @JniArg(cast="size_t") long var3);

    public static final native void memmove(@JniArg(cast="void *", flags={ArgFlag.NO_IN, ArgFlag.CRITICAL}) short[] var0, @JniArg(cast="const void *") long var1, @JniArg(cast="size_t") long var3);

    public static final native void memmove(@JniArg(cast="void *", flags={ArgFlag.NO_IN, ArgFlag.CRITICAL}) int[] var0, @JniArg(cast="const void *") long var1, @JniArg(cast="size_t") long var3);

    public static final native void memmove(@JniArg(cast="void *", flags={ArgFlag.NO_IN, ArgFlag.CRITICAL}) long[] var0, @JniArg(cast="const void *") long var1, @JniArg(cast="size_t") long var3);

    public static final native void memmove(@JniArg(cast="void *", flags={ArgFlag.NO_IN, ArgFlag.CRITICAL}) float[] var0, @JniArg(cast="const void *") long var1, @JniArg(cast="size_t") long var3);

    public static final native void memmove(@JniArg(cast="void *", flags={ArgFlag.NO_IN, ArgFlag.CRITICAL}) double[] var0, @JniArg(cast="const void *") long var1, @JniArg(cast="size_t") long var3);

    public static final native void memmove(@JniArg(cast="void *", flags={ArgFlag.NO_IN, ArgFlag.CRITICAL}) byte[] var0, @JniArg(cast="const void *", flags={ArgFlag.NO_OUT, ArgFlag.CRITICAL}) char[] var1, @JniArg(cast="size_t") long var2);

    public static final native void memmove(@JniArg(cast="void *", flags={ArgFlag.NO_IN, ArgFlag.CRITICAL}) int[] var0, @JniArg(cast="const void *", flags={ArgFlag.NO_OUT, ArgFlag.CRITICAL}) byte[] var1, @JniArg(cast="size_t") long var2);

    @JniMethod(cast="void *")
    public static final native long memset(@JniArg(cast="void *") long var0, int var2, @JniArg(cast="size_t") long var3);

    public static final native int strlen(@JniArg(cast="char *") long var0);

    public static final native void memmove(@JniArg(cast="void *") long var0, @JniArg(cast="const void *", flags={ArgFlag.NO_OUT, ArgFlag.CRITICAL}) bar var2, @JniArg(cast="size_t") long var3);

    public static final native void memmove(@JniArg(cast="void *", flags={ArgFlag.NO_IN, ArgFlag.CRITICAL}) bar var0, @JniArg(cast="const void *") long var1, @JniArg(cast="size_t") long var3);

    public static final native void print_foo(@JniArg(cast="struct foo *") long var0);

    public static final native long foowork(@JniArg(cast="struct foo **") long[] var0, int var1);

    @JniMethod(cast="struct foo *")
    public static final native long foo_add(@JniArg(cast="struct foo *") long var0, int var2);

    @JniMethod(cast="char *")
    public static final native long char_add(@JniArg(cast="char *") long var0, int var2);

    public static final native void callmeback(@JniArg(cast="void (*)(int)", flags={ArgFlag.POINTER_ARG}) long var0);

    static {
        LIBRARY.load();
        Example.init();
    }

    @JniClass(flags={ClassFlag.STRUCT, ClassFlag.CPP})
    static class Range {
        Range() {
        }

        @JniMethod(flags={MethodFlag.CPP_NEW})
        public static final native long Range();

        @JniMethod(flags={MethodFlag.CPP_NEW})
        public static final native long Range(int var0, int var1);

        @JniMethod(flags={MethodFlag.CPP_DELETE})
        public static final native void delete(long var0);

        @JniMethod(flags={MethodFlag.CPP_METHOD})
        public static final native void dump(long var0);

        static {
            LIBRARY.load();
        }
    }

    @JniClass(flags={ClassFlag.STRUCT, ClassFlag.TYPEDEF})
    public static class point {
        @JniField(flags={FieldFlag.CONSTANT}, accessor="sizeof(point)")
        public static int SIZEOF;
        public int x;
        public int y;

        @JniMethod(flags={MethodFlag.CONSTANT_INITIALIZER})
        private static final native void init();

        static {
            LIBRARY.load();
            point.init();
        }
    }

    @JniClass(name="foo", flags={ClassFlag.STRUCT})
    public static class bar {
        @JniField(flags={FieldFlag.CONSTANT}, accessor="sizeof(struct foo)")
        public static int SIZEOF;
        public int a;
        @JniField(cast="size_t")
        public long b;
        public byte[] c = new byte[20];
        @JniField(accessor="c[5]")
        public byte c5;
        @JniField(cast="struct foo *")
        public long prev;

        @JniMethod(flags={MethodFlag.CONSTANT_INITIALIZER})
        private static final native void init();

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.a;
            result = 31 * result + (int)(this.b ^ this.b >>> 32);
            result = 31 * result + Arrays.hashCode(this.c);
            result = 31 * result + this.c5;
            result = 31 * result + (int)(this.prev ^ this.prev >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            bar other = (bar)obj;
            if (this.a != other.a) {
                return false;
            }
            if (this.b != other.b) {
                return false;
            }
            if (!Arrays.equals(this.c, other.c)) {
                return false;
            }
            if (this.c5 != other.c5) {
                return false;
            }
            return this.prev == other.prev;
        }

        public String toString() {
            return "foo [a=" + this.a + ", b=" + this.b + ", c=" + Arrays.toString(this.c) + ", c5=" + this.c5 + ", prev=" + this.prev + "]";
        }

        static {
            LIBRARY.load();
            bar.init();
        }
    }
}

