/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.example;

import java.io.IOException;
import java.net.URI;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtdispatch.Dispatch;
import org.fusesource.hawtdispatch.Task;
import org.fusesource.hawtdispatch.transport.AbstractProtocolCodec;
import org.fusesource.hawtdispatch.transport.DefaultTransportListener;
import org.fusesource.hawtdispatch.transport.ProtocolCodec;
import org.fusesource.hawtdispatch.transport.SslTransport;
import org.fusesource.hawtdispatch.transport.TransportListener;

public class SSLClientExample {
    static final TrustManager[] TRUST_ALL_CERTS = new TrustManager[]{new X509TrustManager(){

        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }};

    public static void main(String[] args) throws Exception {
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, TRUST_ALL_CERTS, new SecureRandom());
        final SslTransport client = new SslTransport();
        client.setDispatchQueue(Dispatch.createQueue());
        client.setSSLContext(sslContext);
        client.setBlockingExecutor((Executor)Executors.newCachedThreadPool());
        client.setProtocolCodec((ProtocolCodec)new BufferProtocolCodec());
        client.connecting(new URI("ssl://localhost:61614"), null);
        final CountDownLatch done = new CountDownLatch(1);
        final Task onClose = new Task(){

            public void run() {
                System.out.println("Client closed.");
                done.countDown();
            }
        };
        client.setTransportListener((TransportListener)new DefaultTransportListener(){

            public void onTransportConnected() {
                System.out.println("Connected");
                client.resumeRead();
                client.offer((Object)new AsciiBuffer("CONNECT\nlogin:admin\npasscode:password\n\n\u0000\n"));
            }

            public void onTransportCommand(Object command) {
                Buffer frame = (Buffer)command;
                System.out.println("Received :" + frame.ascii());
                client.stop(onClose);
            }

            public void onTransportFailure(IOException error) {
                System.out.println("Transport failure :" + error);
                client.stop(onClose);
            }
        });
        client.start(Dispatch.NOOP);
        done.await();
    }

    private static class BufferProtocolCodec
    extends AbstractProtocolCodec {
        private BufferProtocolCodec() {
        }

        protected void encode(Object value) throws IOException {
            Buffer buffer = (Buffer)value;
            this.nextWriteBuffer.write(buffer);
        }

        protected AbstractProtocolCodec.Action initialDecodeAction() {
            return this.readCommand();
        }

        protected AbstractProtocolCodec.Action readCommand() {
            return new AbstractProtocolCodec.Action(){

                public Object apply() throws IOException {
                    int length = BufferProtocolCodec.this.readBuffer.position() - BufferProtocolCodec.this.readStart;
                    if (length > 0) {
                        int offset = BufferProtocolCodec.this.readStart;
                        BufferProtocolCodec.this.readEnd = offset + length;
                        BufferProtocolCodec.this.readStart = BufferProtocolCodec.this.readEnd;
                        return new Buffer(BufferProtocolCodec.this.readBuffer.array(), offset, length);
                    }
                    return null;
                }
            };
        }
    }
}

