/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.example.stomp;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtdispatch.example.stomp.StompLoadClient$;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class StompLoadClient$
implements ScalaObject {
    public static final StompLoadClient$ MODULE$;
    private final long NANOS_PER_SECOND;
    private int producerSleep;
    private int consumerSleep;
    private int producers;
    private int consumers;
    private int sampleInterval;
    private String uri;
    private int bufferSize;
    private int messageSize;
    private boolean useContentLength;
    private String destinationType;
    private int destinationCount;
    private final AtomicLong producerCounter;
    private final AtomicLong consumerCounter;
    private final AtomicBoolean done;

    static {
        new StompLoadClient$();
    }

    public long NANOS_PER_SECOND() {
        return this.NANOS_PER_SECOND;
    }

    public AsciiBuffer toAsciiBuffer(String value) {
        return new AsciiBuffer(value);
    }

    public int producerSleep() {
        return this.producerSleep;
    }

    public void producerSleep_$eq(int n) {
        this.producerSleep = n;
    }

    public int consumerSleep() {
        return this.consumerSleep;
    }

    public void consumerSleep_$eq(int n) {
        this.consumerSleep = n;
    }

    public int producers() {
        return this.producers;
    }

    public void producers_$eq(int n) {
        this.producers = n;
    }

    public int consumers() {
        return this.consumers;
    }

    public void consumers_$eq(int n) {
        this.consumers = n;
    }

    public int sampleInterval() {
        return this.sampleInterval;
    }

    public void sampleInterval_$eq(int n) {
        this.sampleInterval = n;
    }

    public String uri() {
        return this.uri;
    }

    public void uri_$eq(String string) {
        this.uri = string;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public void bufferSize_$eq(int n) {
        this.bufferSize = n;
    }

    public int messageSize() {
        return this.messageSize;
    }

    public void messageSize_$eq(int n) {
        this.messageSize = n;
    }

    public boolean useContentLength() {
        return this.useContentLength;
    }

    public void useContentLength_$eq(boolean bl) {
        this.useContentLength = bl;
    }

    public String destinationType() {
        return this.destinationType;
    }

    public void destinationType_$eq(String string) {
        this.destinationType = string;
    }

    public int destinationCount() {
        return this.destinationCount;
    }

    public void destinationCount_$eq(int n) {
        this.destinationCount = n;
    }

    public AtomicLong producerCounter() {
        return this.producerCounter;
    }

    public AtomicLong consumerCounter() {
        return this.consumerCounter;
    }

    public AtomicBoolean done() {
        return this.done;
    }

    public void main(String[] args) {
        this.run();
    }

    public void run() {
        Predef$.MODULE$.println((Object)"=======================");
        Predef$.MODULE$.println((Object)"Press ENTER to shutdown");
        Predef$.MODULE$.println((Object)"=======================");
        Predef$.MODULE$.println((Object)"");
        this.done().set(false);
        ObjectRef producerThreads$1 = new ObjectRef((Object)Nil$.MODULE$);
        Predef$.MODULE$.intWrapper(0).until(this.producers()).foreach$mVc$sp((Function1)new anonfun.run.1(producerThreads$1));
        ObjectRef consumerThreads$1 = new ObjectRef((Object)Nil$.MODULE$);
        Predef$.MODULE$.intWrapper(0).until(this.consumers()).foreach$mVc$sp((Function1)new anonfun.run.2(consumerThreads$1));
        anon.1 sampleThread = new anon.1();
        sampleThread.start();
        System.in.read();
        Predef$.MODULE$.println((Object)"=======================");
        this.done().set(true);
        ((List)consumerThreads$1.elem).foreach((Function1)new anonfun.run.3());
        ((List)producerThreads$1.elem).foreach((Function1)new anonfun.run.4());
        sampleThread.interrupt();
        sampleThread.join();
        Predef$.MODULE$.println((Object)"Shutdown");
        Predef$.MODULE$.println((Object)"=======================");
    }

    public String toString() {
        return new StringBuilder().append((Object)"--------------------------------------\nStompLoadClient Properties\n--------------------------------------\nuri              = ").append((Object)this.uri()).append((Object)"\n").append((Object)"producers        = ").append((Object)BoxesRunTime.boxToInteger((int)this.producers())).append((Object)"\n").append((Object)"consumers        = ").append((Object)BoxesRunTime.boxToInteger((int)this.consumers())).append((Object)"\n").append((Object)"destinationType  = ").append((Object)this.destinationType()).append((Object)"\n").append((Object)"destinationCount = ").append((Object)BoxesRunTime.boxToInteger((int)this.destinationCount())).append((Object)"\n").append((Object)"messageSize      = ").append((Object)BoxesRunTime.boxToInteger((int)this.messageSize())).append((Object)"\n").append((Object)"producerSleep    = ").append((Object)BoxesRunTime.boxToInteger((int)this.producerSleep())).append((Object)"\n").append((Object)"consumerSleep    = ").append((Object)BoxesRunTime.boxToInteger((int)this.consumerSleep())).append((Object)"\n").append((Object)"bufferSize       = ").append((Object)BoxesRunTime.boxToInteger((int)this.bufferSize())).append((Object)"\n").append((Object)"useContentLength = ").append((Object)BoxesRunTime.boxToBoolean((boolean)this.useContentLength())).append((Object)"\n").append((Object)"sampleInterval   = ").append((Object)BoxesRunTime.boxToInteger((int)this.sampleInterval())).append((Object)"\n").toString();
    }

    public void printRate(String name, AtomicLong counter, long nanos) {
        long c = counter.getAndSet(0L);
        Float rate_per_second = Predef$.MODULE$.float2Float(1.0f * (float)c / (float)nanos * (float)this.NANOS_PER_SECOND());
        Predef$.MODULE$.println((Object)String.format("%s rate: %,.3f per second", name, rate_per_second));
    }

    public String destination(int i) {
        return new StringBuilder().append((Object)"/").append((Object)this.destinationType()).append((Object)"/load-").append((Object)BoxesRunTime.boxToInteger((int)(i % this.destinationCount()))).toString();
    }

    public String message(String name) {
        StringBuffer buffer$1 = new StringBuffer(this.messageSize());
        buffer$1.append(new StringBuilder().append((Object)"Message from ").append((Object)name).append((Object)"\n").toString());
        ((Range.ByOne)Predef$.MODULE$.intWrapper(buffer$1.length()).to(this.messageSize())).foreach((Function1)new anonfun.message.1(buffer$1));
        String rc = buffer$1.toString();
        return rc.length() > this.messageSize() ? rc.substring(0, this.messageSize()) : rc;
    }

    private StompLoadClient$() {
        MODULE$ = this;
        this.NANOS_PER_SECOND = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.SECONDS);
        this.producerSleep = 0;
        this.consumerSleep = 0;
        this.producers = 1;
        this.consumers = 1;
        this.sampleInterval = 5000;
        this.uri = "stomp://127.0.0.1:61613";
        this.bufferSize = 77056;
        this.messageSize = 1024;
        this.useContentLength = true;
        this.destinationType = "queue";
        this.destinationCount = 1;
        this.producerCounter = new AtomicLong();
        this.consumerCounter = new AtomicLong();
        this.done = new AtomicBoolean();
    }
}

