/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.virt.commands;

import java.util.LinkedList;
import java.util.List;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.libvirt.Connect;
import org.libvirt.LibvirtException;

public abstract class LibvirtCommandSupport
extends OsgiCommandSupport {
    private List<Connect> connections = new LinkedList<Connect>();
    @Option(name="--type", multiValued=false, required=false)
    private String type;
    @Option(name="--url", multiValued=false, required=false)
    private String url;

    protected abstract Object doExecute() throws Exception;

    protected Connect getConnection() throws LibvirtException {
        if (this.url != null) {
            Connect connect = null;
            for (Connect conn : this.connections) {
                if (!this.type.equals(conn.getURI().startsWith(this.url))) continue;
                connect = conn;
                break;
            }
            if (connect == null) {
                throw new IllegalArgumentException("Connection with url " + this.url + " not found");
            }
            return connect;
        }
        if (this.type != null) {
            Connect connect = null;
            for (Connect conn : this.connections) {
                if (!this.type.equals(connect.getType())) continue;
                connect = conn;
                break;
            }
            if (connect == null) {
                throw new IllegalArgumentException("Connection type " + this.type + " not found");
            }
            return connect;
        }
        if (this.connections.size() != 1) {
            StringBuilder sb = new StringBuilder();
            for (Connect conn : this.connections) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(conn.getURI());
            }
            throw new IllegalArgumentException("Multiple connections are present, please select one using the --type /--url argument of the following connections: " + sb.toString());
        }
        return this.connections.get(0);
    }

    public List<Connect> getConnections() {
        return this.connections;
    }

    public void setConnections(List<Connect> connections) {
        this.connections = connections;
    }
}

