/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.virt.commands.completer;

import java.util.List;
import java.util.Set;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.StringsCompleter;
import org.fusesource.fabric.virt.commands.LibvrtHelper;
import org.libvirt.Connect;
import org.libvirt.Domain;
import org.libvirt.LibvirtException;

public class DomainNameCompleter
implements Completer {
    private List<Connect> connections;
    private final StringsCompleter delegate = new StringsCompleter();

    public int complete(String buffer, int cursor, List<String> candidates) {
        if (this.connections != null && !this.connections.isEmpty()) {
            for (Connect connect : this.connections) {
                Set<Domain> domains = LibvrtHelper.getDomains(connect, true, true);
                if (domains == null || domains.isEmpty()) continue;
                for (Domain domain : domains) {
                    if (!this.isApplicable(domain)) continue;
                    try {
                        String name = domain.getName();
                        name = name.replaceAll(" ", "\\\\ ");
                        this.delegate.getStrings().add(name);
                    }
                    catch (LibvirtException e) {}
                }
            }
        }
        return this.delegate.complete(buffer, cursor, candidates);
    }

    protected boolean isApplicable(Domain domain) {
        return true;
    }

    public List<Connect> getConnections() {
        return this.connections;
    }

    public void setConnections(List<Connect> connections) {
        this.connections = connections;
    }
}

