/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.virt.commands;

import java.util.LinkedHashSet;
import java.util.Set;
import org.libvirt.Connect;
import org.libvirt.Domain;
import org.libvirt.LibvirtException;

public class LibvrtHelper {
    public static Set<Domain> getDomains(Connect connect, boolean active, boolean defined) {
        LinkedHashSet<Domain> domains = new LinkedHashSet<Domain>();
        if (active) {
            try {
                int[] activeDomainIds;
                for (int domianId : activeDomainIds = connect.listDomains()) {
                    Domain activeDomain = connect.domainLookupByID(domianId);
                    domains.add(activeDomain);
                }
            }
            catch (LibvirtException e) {
                // empty catch block
            }
        }
        if (defined) {
            try {
                String[] definedDomainNames;
                for (String definedDomainName : definedDomainNames = connect.listDefinedDomains()) {
                    Domain definedDomain = connect.domainLookupByName(definedDomainName);
                    domains.add(definedDomain);
                }
            }
            catch (LibvirtException e) {
                // empty catch block
            }
        }
        return domains;
    }

    private LibvrtHelper() {
    }
}

