/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.domain.network;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.vcloud.domain.network.IpRange;

public class IpScope {
    private final boolean inherited;
    @Nullable
    private final String gateway;
    @Nullable
    private final String netmask;
    @Nullable
    private final String dns1;
    @Nullable
    private final String dns2;
    @Nullable
    private final String dnsSuffix;
    private final Set<IpRange> ipRanges = Sets.newLinkedHashSet();
    private final Set<String> allocatedIpAddresses = Sets.newLinkedHashSet();

    public IpScope(boolean inherited, @Nullable String gateway, @Nullable String netmask, @Nullable String dns1, @Nullable String dns2, @Nullable String dnsSuffix, Iterable<IpRange> ipRanges, Iterable<String> allocatedIpAddresses) {
        this.inherited = inherited;
        this.gateway = gateway;
        this.netmask = netmask;
        this.dns1 = dns1;
        this.dns2 = dns2;
        this.dnsSuffix = dnsSuffix;
        Iterables.addAll(this.ipRanges, Preconditions.checkNotNull(ipRanges, "ipRanges"));
        Iterables.addAll(this.allocatedIpAddresses, Preconditions.checkNotNull(allocatedIpAddresses, "allocatedIpAddresses"));
    }

    public boolean isInherited() {
        return this.inherited;
    }

    @Nullable
    public String getGateway() {
        return this.gateway;
    }

    @Nullable
    public String getNetmask() {
        return this.netmask;
    }

    @Nullable
    public String getDns1() {
        return this.dns1;
    }

    @Nullable
    public String getDns2() {
        return this.dns2;
    }

    @Nullable
    public String getDnsSuffix() {
        return this.dnsSuffix;
    }

    public Set<IpRange> getIpRanges() {
        return this.ipRanges;
    }

    public Set<String> getAllocatedIpAddresses() {
        return this.allocatedIpAddresses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IpScope that = (IpScope)IpScope.class.cast(o);
        return Objects.equal(this.inherited, that.inherited) && Objects.equal(this.gateway, that.gateway) && Objects.equal(this.netmask, that.netmask) && Objects.equal(this.dns1, that.dns1) && Objects.equal(this.dns2, that.dns2) && Objects.equal(this.dnsSuffix, that.dnsSuffix) && Objects.equal(this.ipRanges, this.ipRanges) && Objects.equal(this.allocatedIpAddresses, this.allocatedIpAddresses);
    }

    public int hashCode() {
        return Objects.hashCode(this.inherited, this.gateway, this.netmask, this.dns1, this.dns2, this.dnsSuffix, this.ipRanges, this.allocatedIpAddresses);
    }

    public String toString() {
        Objects.ToStringHelper helper = Objects.toStringHelper("").omitNullValues().add("inherited", this.inherited).add("gateway", this.gateway).add("netmask", this.netmask).add("dns1", this.dns1).add("dns2", this.dns2).add("dnsSuffix", this.dnsSuffix);
        if (this.ipRanges.size() > 0) {
            helper.add("ipRanges", this.ipRanges);
        }
        if (this.allocatedIpAddresses.size() > 0) {
            helper.add("allocatedIpAddresses", this.allocatedIpAddresses);
        }
        return helper.toString();
    }
}

