/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.config;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.config.ValueOfConfigurationKeyOrNull;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.domain.VCloudSession;
import org.jclouds.trmk.vcloud_0_8.endpoints.Org;
import org.jclouds.trmk.vcloud_0_8.suppliers.OnlyReferenceTypeFirstWithNameMatchingConfigurationKeyOrDefault;

@Singleton
public class DefaultOrgForUser
implements Supplier<ReferenceType> {
    private final OnlyReferenceTypeFirstWithNameMatchingConfigurationKeyOrDefault selector;
    private final Supplier<VCloudSession> session;

    @Inject
    public DefaultOrgForUser(ValueOfConfigurationKeyOrNull valueOfConfigurationKeyOrNull, @Org Predicate<ReferenceType> defaultSelector, Supplier<VCloudSession> session) {
        this.selector = new OnlyReferenceTypeFirstWithNameMatchingConfigurationKeyOrDefault(Preconditions.checkNotNull(valueOfConfigurationKeyOrNull, "valueOfConfigurationKeyOrNull"), "jclouds.vcloud.defaults.org", Preconditions.checkNotNull(defaultSelector, "defaultSelector"));
        this.session = Preconditions.checkNotNull(session, "session");
    }

    @Override
    public ReferenceType get() {
        return this.selector.apply((Iterable<ReferenceType>)this.session.get().getOrgs().values());
    }
}

