/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sqs.binders;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Maps;
import java.util.Map;
import org.jclouds.aws.binders.BindTableToIndexedFormParams;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;

public class BindSendMessageBatchRequestEntryWithDelaysToIndexedFormParams
extends BindTableToIndexedFormParams
implements MapBinder {
    protected BindSendMessageBatchRequestEntryWithDelaysToIndexedFormParams() {
        super("SendMessageBatchRequestEntry.%d.Id", "SendMessageBatchRequestEntry.%d.MessageBody", "SendMessageBatchRequestEntry.%d.DelaySeconds");
    }

    public Map<String, String> idMessageBody(Iterable<String> input) {
        return Maps.uniqueIndex(input, new Function<String, String>(){
            int index = 1;

            @Override
            public String apply(String input) {
                return this.index++ + "";
            }
        });
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        Map<String, String> idMessageBody = (Map<String, String>)postParams.get("idMessageBody");
        if (idMessageBody == null) {
            idMessageBody = this.idMessageBody((Iterable)postParams.get("messageBodies"));
        }
        int delaySeconds = (Integer)postParams.get("delaySeconds");
        ImmutableTable.Builder<String, String, Integer> builder = ImmutableTable.builder();
        for (Map.Entry<String, String> entry : idMessageBody.entrySet()) {
            builder.put(entry.getKey(), entry.getValue(), delaySeconds);
        }
        return this.bindToRequest(request, builder.build());
    }
}

