/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.slicehost.xml;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import javax.annotation.Resource;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.logging.Logger;
import org.jclouds.slicehost.domain.Backup;
import org.xml.sax.SAXException;

public class BackupHandler
extends ParseSax.HandlerWithResult<Backup> {
    private StringBuilder currentText = new StringBuilder();
    private int id;
    private String name;
    private String sliceId;
    private Date date;
    private Backup backup;
    @Resource
    protected Logger logger = Logger.NULL;

    @Override
    public Backup getResult() {
        return this.backup;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("id")) {
            this.id = Integer.parseInt(this.currentText.toString().trim());
        } else if (qName.equalsIgnoreCase("name")) {
            this.name = this.currentText.toString().trim();
        } else if (qName.equalsIgnoreCase("slice_id")) {
            this.sliceId = this.currentText.toString().trim();
        } else if (qName.equalsIgnoreCase("date")) {
            try {
                this.date = DateFormat.getInstance().parse(this.currentText.toString().trim());
            }
            catch (ParseException e) {
                this.logger.warn(e, "error parsing: %s", this.currentText.toString().trim());
            }
        } else if (qName.equalsIgnoreCase("backup")) {
            this.backup = new Backup(this.id, this.name, this.sliceId, this.date);
            this.id = -1;
            this.name = null;
            this.sliceId = null;
            this.date = null;
        }
        this.currentText = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

