/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.slicehost.filters;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.location.Provider;

@Singleton
public class SlicehostBasic
implements HttpRequestFilter {
    private final Supplier<Credentials> creds;

    @Inject
    public SlicehostBasic(@Provider Supplier<Credentials> creds) {
        this.creds = Preconditions.checkNotNull(creds, "creds");
    }

    @Override
    public HttpRequest filter(HttpRequest request) throws HttpException {
        return ((HttpRequest.Builder)request.toBuilder().replaceHeader("Authorization", String.format("Basic %s", CryptoStreams.base64(this.creds.get().identity.getBytes())))).build();
    }
}

