/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.slicehost;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnVoidOnNotFoundOr404;
import org.jclouds.slicehost.binders.BindCreateSliceToXmlPayload;
import org.jclouds.slicehost.domain.Backup;
import org.jclouds.slicehost.domain.Flavor;
import org.jclouds.slicehost.domain.Image;
import org.jclouds.slicehost.domain.Slice;
import org.jclouds.slicehost.filters.SlicehostBasic;
import org.jclouds.slicehost.xml.BackupHandler;
import org.jclouds.slicehost.xml.BackupsHandler;
import org.jclouds.slicehost.xml.FlavorHandler;
import org.jclouds.slicehost.xml.FlavorsHandler;
import org.jclouds.slicehost.xml.ImageHandler;
import org.jclouds.slicehost.xml.ImagesHandler;
import org.jclouds.slicehost.xml.SliceHandler;
import org.jclouds.slicehost.xml.SlicesHandler;

@RequestFilters(value={SlicehostBasic.class})
public interface SlicehostAsyncClient {
    @GET
    @Path(value="/slices.xml")
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    @XMLResponseParser(value=SlicesHandler.class)
    public ListenableFuture<? extends Set<Slice>> listSlices();

    @GET
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @Path(value="/slices/{id}.xml")
    @XMLResponseParser(value=SliceHandler.class)
    public ListenableFuture<Slice> getSlice(@PathParam(value="id") int var1);

    @DELETE
    @ExceptionParser(value=ReturnVoidOnNotFoundOr404.class)
    @Path(value="/slices/{id}/destroy.xml")
    public ListenableFuture<Void> destroySlice(@PathParam(value="id") int var1);

    @PUT
    @Path(value="/slices/{id}/reboot.xml")
    public ListenableFuture<Void> rebootSlice(@PathParam(value="id") int var1);

    @PUT
    @Path(value="/slices/{id}/hard_reboot.xml")
    public ListenableFuture<Void> hardRebootSlice(@PathParam(value="id") int var1);

    @POST
    @Path(value="/slices.xml")
    @MapBinder(value=BindCreateSliceToXmlPayload.class)
    @XMLResponseParser(value=SliceHandler.class)
    public ListenableFuture<Slice> createSlice(@PayloadParam(value="name") String var1, @PayloadParam(value="image_id") int var2, @PayloadParam(value="flavor_id") int var3);

    @PUT
    @Path(value="/slices/{id}/rebuild.xml")
    public ListenableFuture<Void> rebuildSliceFromImage(@PathParam(value="id") int var1, @QueryParam(value="image_id") int var2);

    @PUT
    @Path(value="/slices/{id}/rebuild.xml")
    public ListenableFuture<Void> rebuildSliceFromBackup(@PathParam(value="id") int var1, @QueryParam(value="backup_id") int var2);

    @GET
    @Path(value="/flavors.xml")
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    @XMLResponseParser(value=FlavorsHandler.class)
    public ListenableFuture<? extends Set<Flavor>> listFlavors();

    @GET
    @Path(value="/flavors/{id}.xml")
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @XMLResponseParser(value=FlavorHandler.class)
    public ListenableFuture<Flavor> getFlavor(@PathParam(value="id") int var1);

    @GET
    @Path(value="/images.xml")
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    @XMLResponseParser(value=ImagesHandler.class)
    public ListenableFuture<? extends Set<Image>> listImages();

    @GET
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @Path(value="/images/{id}.xml")
    @XMLResponseParser(value=ImageHandler.class)
    public ListenableFuture<Image> getImage(@PathParam(value="id") int var1);

    @GET
    @Path(value="/backups.xml")
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    @XMLResponseParser(value=BackupsHandler.class)
    public ListenableFuture<? extends Set<Backup>> listBackups();

    @GET
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @Path(value="/backups/{id}.xml")
    @XMLResponseParser(value=BackupHandler.class)
    public ListenableFuture<Backup> getBackup(@PathParam(value="id") int var1);
}

