/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.domain;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.net.URI;
import java.util.Map;
import org.jclouds.scriptbuilder.domain.InterpretableStatement;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.Statement;

public class PipeHttpResponseTo
extends InterpretableStatement {
    public PipeHttpResponseTo(Statement toExec, String method, URI endpoint, Multimap<String, String> headers) {
        super(String.format("%s -X %s %s %s |(%s)\n", "curl -q -s -S -L --connect-timeout 10 --max-time 600 --retry 20", method, Joiner.on(' ').join(Iterables.transform(headers.entries(), new Function<Map.Entry<String, String>, String>(){

            @Override
            public String apply(Map.Entry<String, String> from) {
                return String.format("-H \"%s: %s\"", from.getKey(), from.getValue());
            }
        })), endpoint.toASCIIString(), toExec.render(OsFamily.UNIX)));
    }

    @Override
    public String render(OsFamily family) {
        Preconditions.checkArgument(family != OsFamily.WINDOWS, "windows not supported");
        return super.render(family);
    }
}

