/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.xml;

import com.google.inject.Inject;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.route53.domain.RecordSet;
import org.jclouds.route53.domain.RecordSetIterable;
import org.jclouds.route53.xml.ResourceRecordSetHandler;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class ListResourceRecordSetsResponseHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<RecordSetIterable> {
    private final ResourceRecordSetHandler resourceRecordSetHandler;
    private StringBuilder currentText = new StringBuilder();
    private RecordSetIterable.Builder builder = RecordSetIterable.builder();
    private boolean inResourceRecordSets;

    @Inject
    public ListResourceRecordSetsResponseHandler(ResourceRecordSetHandler resourceRecordSetHandler) {
        this.resourceRecordSetHandler = resourceRecordSetHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RecordSetIterable getResult() {
        try {
            RecordSetIterable recordSetIterable = this.builder.build();
            return recordSetIterable;
        }
        finally {
            this.builder = RecordSetIterable.builder();
        }
    }

    @Override
    public void startElement(String url, String name, String qName, Attributes attributes) {
        if (SaxUtils.equalsOrSuffix(qName, "ResourceRecordSets")) {
            this.inResourceRecordSets = true;
        }
        if (this.inResourceRecordSets) {
            this.resourceRecordSetHandler.startElement(url, name, qName, attributes);
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (this.inResourceRecordSets) {
            if (qName.equals("ResourceRecordSets")) {
                this.inResourceRecordSets = false;
            } else if (qName.equals("ResourceRecordSet")) {
                this.builder.add(this.resourceRecordSetHandler.getResult());
            } else {
                this.resourceRecordSetHandler.endElement(uri, name, qName);
            }
        } else if (qName.equals("NextRecordName")) {
            this.builder.nextRecordName(SaxUtils.currentOrNull(this.currentText));
        } else if (qName.equals("NextRecordType")) {
            this.builder.nextRecordType(RecordSet.Type.valueOf(SaxUtils.currentOrNull(this.currentText)));
        } else if (qName.equals("NextRecordIdentifier")) {
            this.builder.nextRecordIdentifier(SaxUtils.currentOrNull(this.currentText));
        }
        this.currentText = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.inResourceRecordSets) {
            this.resourceRecordSetHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }
}

